CREATE DICTIONARY IF NOT EXISTS dict_ipreg ON CLUSTER '{cluster}'
(
    prefix String CODEC(ZSTD(7)),
    region_id UInt32
)
PRIMARY KEY prefix
SOURCE(HTTP(url 'https://strm.s3.mds.yandex.net/clickhouse/dicts/IPREG.csv' format 'CSV'))
LAYOUT(IP_TRIE())
LIFETIME(MIN 3500 MAX 3600);

CREATE DICTIONARY IF NOT EXISTS dict_as_name ON CLUSTER '{cluster}' (
    asn UInt32,
    name String CODEC(ZSTD(7)),
    desc String
)
PRIMARY KEY asn
SOURCE(HTTP(url 'https://strm.s3.mds.yandex.net/clickhouse/dicts/as_name.csv' format 'CSV'))
LAYOUT(HASHED())
LIFETIME(MIN 3500 MAX 3600);
