AUTH_TOKEN=`cat ~/.yc.token`

FOLDER_ID=foo8debsmodt2n1bj125

function patch_transfer() {
    local transfer_id=$1
    local cpu=$2
    local ram=$3
    local jobs=$4

    curl -X PATCH \
        --silent \
        "https://cdc.n.yandex-team.ru/v1/connector/scale" \
        -H "accept: application/json" \
        -H "Authorization: $AUTH_TOKEN" \
        -H "Content-Type: application/json" \
        -d "{ \"id\": \"$transfer_id\", \"runtime\": { \"yt_runtime\": { \"cpu\": $cpu, \"job_count\": \"$jobs\", \"ram\": \"$ram\" } }}" | json_pp
}

function patch_transfer_multi() {
    local transfer_id=$1
    local cpu=$2
    local ram=$3
    local jobs=$4

    curl -X PATCH \
        --silent \
        "https://cdc.n.yandex-team.ru/v1/connector/scale" \
        -H "accept: application/json" \
        -H "Authorization: $AUTH_TOKEN" \
        -H "Content-Type: application/json" \
        -d "{
            \"id\": \"$transfer_id\",
            \"runtime\": {
                \"multi_yt_runtime\": {
                    \"yts\": [
                        {
                            \"cpu\": $cpu,
                            \"job_count\": \"$jobs\",
                            \"ram\": \"$ram\"
                        }
                    ]
                }
            }
        }" | json_pp
}

function get_endpoint() {
    local endpoint_id=$1
    curl -X GET \
        --silent \
        -H "accept: application/json" \
        -H "Authorization: $AUTH_TOKEN" \
        -H "Content-Type: application/json" \
        "https://cdc.n.yandex-team.ru/v1/endpoint/$endpoint_id" | json_pp
}

function update_endpoint() {
    local id=$1
    local path=$2

    curl -X PATCH \
        --silent \
        -H "accept: application/json" \
        -H "Authorization: $AUTH_TOKEN" \
        -H "Content-Type: application/json" \
        "https://cdc.n.yandex-team.ru/v1/endpoint/$id" \
        -d "@$path" | json_pp
}

function create_endpoint() {
    local path=$1

    curl -X POST \
        --silent \
        -H "accept: application/json" \
        -H "Authorization: $AUTH_TOKEN" \
        -H "Content-Type: application/json" \
        "https://cdc.n.yandex-team.ru/v1/endpoint" \
        -d "@$path" | json_pp
}

function activate_transfer() {
    local transfer_id=$1

    curl -X POST \
        --silent \
        -H "accept: application/json" \
        -H "Authorization: $AUTH_TOKEN" \
        -H "Content-Type: application/json" \
        "https://cdc.n.yandex-team.ru/v1/transfer/$transfer_id:activate" \
        -d"{\"transfer_id\":\"$transfer_id\"}" | json_pp
}

function deactivate_transfer() {
    local transfer_id=$1

    curl -X POST \
        --silent \
        -H "accept: application/json" \
        -H "Authorization: $AUTH_TOKEN" \
        -H "Content-Type: application/json" \
        "https://cdc.n.yandex-team.ru/v1/transfer/$transfer_id:deactivate" \
        -d"{\"transfer_id\":\"$transfer_id\"}" | json_pp
}

function get_transfer() {
    local transfer_id=$1

    curl -X GET \
        --silent \
        -H "accept: application/json" \
        -H "Authorization: $AUTH_TOKEN" \
        -H "Content-Type: application/json" \
        "https://cdc.n.yandex-team.ru/v1/transfer/$transfer_id" | json_pp
}

function transfer_logs() {
    local transfer_id=$1

    curl -X GET \
        --silent \
        -H "accept: application/json" \
        -H "Authorization: $AUTH_TOKEN" \
        -H "Content-Type: application/json" \
        "https://cdc.n.yandex-team.ru/v1/transfers/logs?stream_name=-1&log_group_id=$transfer_id&page_size=100" | json_pp
}

function cancel_operation() {
    local operation_id=$1

    curl -X DELETE \
        --silent \
        -H "accept: application/json" \
        -H "Authorization: $AUTH_TOKEN" \
        -H "Content-Type: application/json" \
        "https://cdc.n.yandex-team.ru/v1/operation/$operation_id" | json_pp
}

function get_transfers() {
    curl --silent \
        "https://cdc.n.yandex-team.ru/v1/transfers/list/$FOLDER_ID?page_size=200" \
        -H "accept: application/json" \
        -H "Authorization: $AUTH_TOKEN" \
        -H "Content-Type: application/json" | jq -c ".transfers[]|[.id,.name,.status]"
}

function get_endpoints() {
    curl --silent \
        "https://cdc.n.yandex-team.ru/v1/endpoints/list/$FOLDER_ID" \
        -H "accept: application/json" \
        -H "Authorization: $AUTH_TOKEN" \
        -H "Content-Type: application/json" | jq .
}

function deactivate_all_transfers()  {
    get_transfers | jq -r ".[0]" | while read line; do deactivate_transfer $line; done
}

function activate_all_transfers()  {
    get_transfers | jq -r ".[0]" | while read line; do activate_transfer $line; done
}
