CREATE TABLE IF NOT EXISTS logs._imap_imap_typed_log_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `timezone` LowCardinality(String) CODEC(ZSTD(7)),
    `type` LowCardinality(String) CODEC(ZSTD(7)),
    `status` LowCardinality(String) CODEC(ZSTD(7)),
    `session` String CODEC(ZSTD(7)),
    `selected_folder_id` Int32,
    `command_name` LowCardinality(String) CODEC(ZSTD(7)),
    `command_text` String CODEC(ZSTD(7)),
    `command_length` Int32,
    `messages_loaded_from_metabackend_count` Int32,
    `messages_loaded_from_mdb_count` Int32,
    `storage_requests_count` Int32,
    `mbody_cache_hit_count` Int32,
    `total_time` Float32,
    `client_name` String CODEC(ZSTD(7)),
    `client_os` String CODEC(ZSTD(7)),
    `client_os_version` String CODEC(ZSTD(7)),
    `client_vendor` String CODEC(ZSTD(7)),
    `client_version` String CODEC(ZSTD(7)),
    `email` String CODEC(ZSTD(7)),
    `ip` String CODEC(ZSTD(7)),
    `uid` String CODEC(ZSTD(7)),
    `details_loaded` UInt8,
    `extra` String CODEC(ZSTD(7)),
    `messages_count` Int32,
    `reason` String CODEC(ZSTD(7)),
    `enable_auth_plain` UInt8,
    `enable_auto_expunge` UInt8,
    `localize_imap` UInt8,
    `rename_enabled` UInt8,
    `SearchNodeAnd` UInt8,
    `SearchNodeFlags` UInt32,
    `SearchNodeNot` UInt8,
    `SearchNodeSeqsetUid` UInt8,
    `SearchNodeMessageId` UInt32,
    `SearchNodeSeqset` UInt8,
    `SearchNodeDate` UInt8,
    `SearchNodeDoNothing` UInt8,
    `SearchNodeOr` UInt32,
    `SearchByExpression` UInt8,
    `expunged` UInt8,
    `_lb_extra_server` String CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_imap_imap_typed_log_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;

CREATE TABLE IF NOT EXISTS logs.imap_typed_log ON CLUSTER '{cluster}' AS logs._imap_imap_typed_log_part ENGINE = Distributed('{cluster}', logs, _imap_imap_typed_log_part, rand());
