CREATE TABLE IF NOT EXISTS logs._magic_prod_magic_security_log_local ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`_timestamp`) CODEC(DoubleDelta, LZ4),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime ALIAS _timestamp,
    `src_ip` String CODEC(ZSTD(7)),
    `uid` String CODEC(ZSTD(7)),
    `user` String CODEC(ZSTD(7)),
    `time` String CODEC(ZSTD(7)),
    `request` String CODEC(ZSTD(7)),
    `method` LowCardinality(String) MATERIALIZED extract(request, '(\\S+)\ '),
    `path` String MATERIALIZED extract(request, '\\S+ (\\S+)\ ') CODEC(ZSTD(7)),
    `protocol` LowCardinality(String) MATERIALIZED extract(request, '\\S+ \\S+ (\\S+)'),
    `status` UInt16,
    `byte` UInt32,
    `http_referer` String CODEC(ZSTD(7)),
    `http_user_agent` String CODEC(ZSTD(7)),
    `yandexuid` String CODEC(ZSTD(7)),
    `ipv4` IPv4 MATERIALIZED if(isIPv4String(src_ip), IPv4StringToNum(src_ip), CAST(0, 'IPv4')),
    `ipv6` IPv6 MATERIALIZED if(isIPv4String(src_ip) OR isIPv6String(src_ip), src_ip, '::'),
    `_lb_extra_server` String CODEC(ZSTD(7)),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_magic_prod_magic_security_log_local', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, _timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;

CREATE TABLE IF NOT EXISTS logs.magic_security_log ON CLUSTER '{cluster}' AS logs._magic_prod_magic_security_log_local ENGINE = Distributed('{cluster}', logs, _magic_prod_magic_security_log_local, rand());
