CREATE TABLE IF NOT EXISTS logs._mail_mail_api_access_tskv_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `timezone` LowCardinality(String),
    `status` UInt16,
    `protocol` LowCardinality(String),
    `method` LowCardinality(String),
    `request` String CODEC(ZSTD(7)),
    `referer` String CODEC(ZSTD(7)),
    `cookies` String CODEC(ZSTD(7)),
    `yandexuid` String MATERIALIZED extract(cookies, 'yandexuid=(\\d+)') CODEC(ZSTD(7)),
    `user_agent` String CODEC(ZSTD(7)),
    `vhost` String CODEC(ZSTD(7)),
    `ip` String CODEC(ZSTD(7)),
    `x_forwarded_for` String CODEC(ZSTD(7)),
    `x_real_ip` String CODEC(ZSTD(7)),
    `ipv4` IPv4 MATERIALIZED if(isIPv4String(x_real_ip), IPv4StringToNum(x_real_ip), CAST(0, 'IPv4')),
    `ipv6` IPv6 MATERIALIZED if(isIPv4String(x_real_ip) OR isIPv6String(x_real_ip), x_real_ip, '::'),
    `upstream_addr` LowCardinality(String),
    `upstream_response_time` Float32,
    `upstream_status` UInt16,
    `request_id` String CODEC(ZSTD(7)),
    `request_length` UInt16,
    `bytes_sent` UInt16,
    `request_time` Float32,
    `_lb_extra_server` String CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_mail_api_access_tskv_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;

CREATE TABLE IF NOT EXISTS logs.api_access_tskv ON CLUSTER '{cluster}' AS logs._mail_mail_api_access_tskv_part ENGINE = Distributed('{cluster}', logs, _mail_mail_api_access_tskv_part, rand());

CREATE TABLE IF NOT EXISTS logs._mail_mail_api_v3_access_tskv_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `timezone` LowCardinality(String),
    `status` UInt16,
    `protocol` LowCardinality(String),
    `method` LowCardinality(String),
    `request` String CODEC(ZSTD(7)),
    `referer` String CODEC(ZSTD(7)),
    `cookies` String CODEC(ZSTD(7)),
    `yandexuid` String MATERIALIZED extract(cookies, 'yandexuid=(\\d+)') CODEC(ZSTD(7)),
    `user_agent` String CODEC(ZSTD(7)),
    `vhost` String CODEC(ZSTD(7)),
    `ip` String CODEC(ZSTD(7)),
    `x_forwarded_for` String CODEC(ZSTD(7)),
    `x_real_ip` String CODEC(ZSTD(7)),
    `ipv4` IPv4 MATERIALIZED if(isIPv4String(x_real_ip), IPv4StringToNum(x_real_ip), CAST(0, 'IPv4')),
    `ipv6` IPv6 MATERIALIZED if(isIPv4String(x_real_ip) OR isIPv6String(x_real_ip), x_real_ip, '::'),
    `upstream_addr` LowCardinality(String),
    `upstream_response_time` Float32,
    `upstream_status` UInt16,
    `request_id` String CODEC(ZSTD(7)),
    `request_length` UInt16,
    `bytes_sent` UInt16,
    `request_time` Float32,
    `_lb_extra_server` String CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_mail_api_v3_access_tskv_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;

CREATE TABLE IF NOT EXISTS logs.api_v3_access_tskv ON CLUSTER '{cluster}' AS logs._mail_mail_api_v3_access_tskv_part ENGINE = Distributed('{cluster}', logs, _mail_mail_api_v3_access_tskv_part, rand());


CREATE TABLE IF NOT EXISTS logs._mail_mail_compose_access_tskv_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `timezone` LowCardinality(String),
    `status` UInt16,
    `protocol` LowCardinality(String),
    `method` LowCardinality(String),
    `request` String CODEC(ZSTD(7)),
    `referer` String CODEC(ZSTD(7)),
    `cookies` String CODEC(ZSTD(7)),
    `yandexuid` String MATERIALIZED extract(cookies, 'yandexuid=(\\d+)') CODEC(ZSTD(7)),
    `user_agent` String CODEC(ZSTD(7)),
    `vhost` String CODEC(ZSTD(7)),
    `ip` String CODEC(ZSTD(7)),
    `x_forwarded_for` String CODEC(ZSTD(7)),
    `x_real_ip` String CODEC(ZSTD(7)),
    `ipv4` IPv4 MATERIALIZED if(isIPv4String(x_real_ip), IPv4StringToNum(x_real_ip), CAST(0, 'IPv4')),
    `ipv6` IPv6 MATERIALIZED if(isIPv4String(x_real_ip) OR isIPv6String(x_real_ip), x_real_ip, '::'),
    `upstream_addr` LowCardinality(String),
    `upstream_response_time` Float32,
    `upstream_status` UInt16,
    `request_id` String CODEC(ZSTD(7)),
    `request_length` UInt16,
    `bytes_sent` UInt16,
    `request_time` Float32,
    `_lb_extra_server` String CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_mail_compose_access_tskv_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;

CREATE TABLE IF NOT EXISTS logs.compose_access_tskv ON CLUSTER '{cluster}' AS logs._mail_mail_compose_access_tskv_part ENGINE = Distributed('{cluster}', logs, _mail_mail_compose_access_tskv_part, rand());


CREATE TABLE IF NOT EXISTS logs._mail_mail_homer_access_tskv_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `timezone` LowCardinality(String),
    `status` UInt16,
    `protocol` LowCardinality(String),
    `method` LowCardinality(String),
    `request` String CODEC(ZSTD(7)),
    `referer` String CODEC(ZSTD(7)),
    `cookies` String CODEC(ZSTD(7)),
    `yandexuid` String MATERIALIZED extract(cookies, 'yandexuid=(\\d+)') CODEC(ZSTD(7)),
    `user_agent` String CODEC(ZSTD(7)),
    `vhost` String CODEC(ZSTD(7)),
    `ip` String CODEC(ZSTD(7)),
    `x_forwarded_for` String CODEC(ZSTD(7)),
    `x_real_ip` String CODEC(ZSTD(7)),
    `ipv4` IPv4 MATERIALIZED if(isIPv4String(x_real_ip), IPv4StringToNum(x_real_ip), CAST(0, 'IPv4')),
    `ipv6` IPv6 MATERIALIZED if(isIPv4String(x_real_ip) OR isIPv6String(x_real_ip), x_real_ip, '::'),
    `upstream_addr` LowCardinality(String),
    `upstream_response_time` Float32,
    `upstream_status` UInt16,
    `request_id` String CODEC(ZSTD(7)),
    `request_length` UInt16,
    `bytes_sent` UInt16,
    `request_time` Float32,
    `_lb_extra_server` String CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_mail_homer_access_tskv_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;

CREATE TABLE IF NOT EXISTS logs._mail_mail_homer_access_tskv ON CLUSTER '{cluster}' AS logs._mail_mail_homer_access_tskv_part ENGINE = Distributed('{cluster}', logs, _mail_mail_homer_access_tskv_part, rand());
CREATE TABLE IF NOT EXISTS logs.homer_access_tskv ON CLUSTER '{cluster}' AS logs._mail_mail_homer_access_tskv_part ENGINE = Distributed('{cluster}', logs, _mail_mail_homer_access_tskv_part, rand());


CREATE TABLE IF NOT EXISTS logs._mail_mail_lite_access_tskv_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `timezone` LowCardinality(String),
    `status` UInt16,
    `protocol` LowCardinality(String),
    `method` LowCardinality(String),
    `request` String CODEC(ZSTD(7)),
    `referer` String CODEC(ZSTD(7)),
    `cookies` String CODEC(ZSTD(7)),
    `yandexuid` String MATERIALIZED extract(cookies, 'yandexuid=(\\d+)') CODEC(ZSTD(7)),
    `user_agent` String CODEC(ZSTD(7)),
    `vhost` String CODEC(ZSTD(7)),
    `ip` String CODEC(ZSTD(7)),
    `x_forwarded_for` String CODEC(ZSTD(7)),
    `x_real_ip` String CODEC(ZSTD(7)),
    `ipv4` IPv4 MATERIALIZED if(isIPv4String(x_real_ip), IPv4StringToNum(x_real_ip), CAST(0, 'IPv4')),
    `ipv6` IPv6 MATERIALIZED if(isIPv4String(x_real_ip) OR isIPv6String(x_real_ip), x_real_ip, '::'),
    `upstream_addr` LowCardinality(String),
    `upstream_response_time` Float32,
    `upstream_status` UInt16,
    `request_id` String CODEC(ZSTD(7)),
    `request_length` UInt16,
    `bytes_sent` UInt16,
    `request_time` Float32,
    `_lb_extra_server` String CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_mail_lite_access_tskv_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;

CREATE TABLE IF NOT EXISTS logs.lite_access_tskv ON CLUSTER '{cluster}' AS logs._mail_mail_lite_access_tskv_part ENGINE = Distributed('{cluster}', logs, _mail_mail_lite_access_tskv_part, rand());


CREATE TABLE IF NOT EXISTS logs._mail_mail_mobile_api_access_tskv_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `timezone` LowCardinality(String),
    `status` UInt16,
    `protocol` LowCardinality(String),
    `method` LowCardinality(String),
    `request` String CODEC(ZSTD(7)),
    `referer` String CODEC(ZSTD(7)),
    `cookies` String CODEC(ZSTD(7)),
    `yandexuid` String MATERIALIZED extract(cookies, 'yandexuid=(\\d+)') CODEC(ZSTD(7)),
    `user_agent` String CODEC(ZSTD(7)),
    `vhost` String CODEC(ZSTD(7)),
    `ip` String CODEC(ZSTD(7)),
    `x_forwarded_for` String CODEC(ZSTD(7)),
    `x_real_ip` String CODEC(ZSTD(7)),
    `ipv4` IPv4 MATERIALIZED if(isIPv4String(x_real_ip), IPv4StringToNum(x_real_ip), CAST(0, 'IPv4')),
    `ipv6` IPv6 MATERIALIZED if(isIPv4String(x_real_ip) OR isIPv6String(x_real_ip), x_real_ip, '::'),
    `upstream_addr` LowCardinality(String),
    `upstream_response_time` Float32,
    `upstream_status` UInt16,
    `request_id` String CODEC(ZSTD(7)),
    `request_length` UInt16,
    `bytes_sent` UInt16,
    `request_time` Float32,
    `uuid` String MATERIALIZED extract(request, 'uuid=([a-f\\d]+)') CODEC(ZSTD(7)),
    `_lb_extra_server` String CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_mail_mobile_api_access_tskv_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;

CREATE TABLE IF NOT EXISTS logs.mobile_api_access_tskv ON CLUSTER '{cluster}' AS logs._mail_mail_mobile_api_access_tskv_part ENGINE = Distributed('{cluster}', logs, _mail_mail_mobile_api_access_tskv_part, rand());


CREATE TABLE IF NOT EXISTS logs._mail_nginx_access_tskv_local ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `timezone` LowCardinality(String),
    `status` UInt16,
    `protocol` LowCardinality(String),
    `method` LowCardinality(String),
    `request` String CODEC(ZSTD(7)),
    `referer` String CODEC(ZSTD(7)),
    `cookies` String CODEC(ZSTD(7)),
    `yandexuid` String MATERIALIZED extract(cookies, 'yandexuid=(\\d+)') CODEC(ZSTD(7)),
    `emptyCookie` Boolean MATERIALIZED `cookies` = '-',
    `user_agent` String CODEC(ZSTD(7)),
    `vhost` String CODEC(ZSTD(7)),
    `ip` String CODEC(ZSTD(7)),
    `x_forwarded_for` String CODEC(ZSTD(7)),
    `x_real_ip` String CODEC(ZSTD(7)),
    `https` LowCardinality(String),
    `upstream_addr` LowCardinality(String),
    `upstream_response_time` String CODEC(ZSTD(7)),
    `upstream_status` String CODEC(ZSTD(7)),
    `upstream_addrs` Array(String) MATERIALIZED splitByString(' : ', `upstream_addr`),
    `upstream_response_times` Array(Float32) MATERIALIZED arrayMap(x -> toFloat32OrZero(x), splitByString(' : ', `upstream_response_time`)),
    `upstream_statuses` Array(UInt16) MATERIALIZED arrayMap(x -> toUInt16OrZero(x), splitByString(' : ', `upstream_status`)),
    `request_id` String CODEC(ZSTD(7)),
    `request_length` UInt16,
    `bytes_sent` UInt16,
    `request_time` Float32,
    `antirobot_status` LowCardinality(String) CODEC(ZSTD(7)),
    `_lb_extra_server` String CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_nginx_access_tskv_local', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(14) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;

CREATE TABLE IF NOT EXISTS logs.nginx_access_tskv ON CLUSTER '{cluster}' AS logs._mail_nginx_access_tskv_local ENGINE = Distributed('{cluster}', logs, _mail_nginx_access_tskv_local, rand());



CREATE TABLE IF NOT EXISTS logs._mail_quinn_access_tskv_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `timezone` LowCardinality(String),
    `status` UInt16,
    `protocol` LowCardinality(String),
    `method` LowCardinality(String),
    `request` String CODEC(ZSTD(7)),
    `referer` String CODEC(ZSTD(7)),
    `cookies` String CODEC(ZSTD(7)),
    `yandexuid` String MATERIALIZED extract(cookies, 'yandexuid=(\\d+)') CODEC(ZSTD(7)),
    `user_agent` String CODEC(ZSTD(7)),
    `vhost` String CODEC(ZSTD(7)),
    `ip` String CODEC(ZSTD(7)),
    `x_forwarded_for` String CODEC(ZSTD(7)),
    `x_real_ip` String CODEC(ZSTD(7)),
    `ipv4` IPv4 MATERIALIZED if(isIPv4String(x_real_ip), IPv4StringToNum(x_real_ip), CAST(0, 'IPv4')),
    `ipv6` IPv6 MATERIALIZED if(isIPv4String(x_real_ip) OR isIPv6String(x_real_ip), x_real_ip, '::'),
    `upstream_addr` LowCardinality(String),
    `upstream_response_time` Float32,
    `upstream_status` UInt16,
    `request_id` String CODEC(ZSTD(7)),
    `request_length` UInt16,
    `bytes_sent` UInt16,
    `request_time` Float32,
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_quinn_access_tskv_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;

CREATE TABLE IF NOT EXISTS logs.quinn_access_tskv ON CLUSTER '{cluster}' AS logs._mail_quinn_access_tskv_part ENGINE = Distributed('{cluster}', logs, _mail_quinn_access_tskv_part, rand());


CREATE TABLE IF NOT EXISTS logs._mail_u2709_access_tskv_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `timezone` LowCardinality(String),
    `status` UInt16,
    `protocol` LowCardinality(String),
    `method` LowCardinality(String),
    `request` String CODEC(ZSTD(7)),
    `referer` String CODEC(ZSTD(7)),
    `cookies` String CODEC(ZSTD(7)),
    `yandexuid` String MATERIALIZED extract(cookies, 'yandexuid=(\\d+)') CODEC(ZSTD(7)),
    `user_agent` String CODEC(ZSTD(7)),
    `vhost` String CODEC(ZSTD(7)),
    `ip` String CODEC(ZSTD(7)),
    `x_forwarded_for` String CODEC(ZSTD(7)),
    `x_real_ip` String CODEC(ZSTD(7)),
    `ipv4` IPv4 MATERIALIZED if(isIPv4String(x_real_ip), IPv4StringToNum(x_real_ip), CAST(0, 'IPv4')),
    `ipv6` IPv6 MATERIALIZED if(isIPv4String(x_real_ip) OR isIPv6String(x_real_ip), x_real_ip, '::'),
    `upstream_addr` LowCardinality(String),
    `upstream_response_time` Float32,
    `upstream_status` UInt16,
    `request_id` String CODEC(ZSTD(7)),
    `request_length` UInt16,
    `bytes_sent` UInt16,
    `request_time` Float32,
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_u2709_access_tskv_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;

CREATE TABLE IF NOT EXISTS logs.u2709_access_tskv ON CLUSTER '{cluster}' AS logs._mail_u2709_access_tskv_part ENGINE = Distributed('{cluster}', logs, _mail_u2709_access_tskv_part, rand());


CREATE TABLE IF NOT EXISTS logs._mail_web_api_access_tskv_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `timezone` LowCardinality(String),
    `status` UInt16,
    `protocol` LowCardinality(String),
    `method` LowCardinality(String),
    `request` String CODEC(ZSTD(7)),
    `referer` String CODEC(ZSTD(7)),
    `cookies` String CODEC(ZSTD(7)),
    `yandexuid` String MATERIALIZED extract(cookies, 'yandexuid=(\\d+)') CODEC(ZSTD(7)),
    `user_agent` String CODEC(ZSTD(7)),
    `vhost` String CODEC(ZSTD(7)),
    `ip` String CODEC(ZSTD(7)),
    `x_forwarded_for` String CODEC(ZSTD(7)),
    `x_real_ip` String CODEC(ZSTD(7)),
    `ipv4` IPv4 MATERIALIZED if(isIPv4String(x_real_ip), IPv4StringToNum(x_real_ip), CAST(0, 'IPv4')),
    `ipv6` IPv6 MATERIALIZED if(isIPv4String(x_real_ip) OR isIPv6String(x_real_ip), x_real_ip, '::'),
    `upstream_addr` LowCardinality(String),
    `upstream_response_time` Float32,
    `upstream_status` UInt16,
    `request_id` String CODEC(ZSTD(7)),
    `request_length` UInt16,
    `bytes_sent` UInt16,
    `request_time` Float32,
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_web_api_access_tskv_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;

CREATE TABLE IF NOT EXISTS logs.web_api_access_tskv ON CLUSTER '{cluster}' AS logs._mail_web_api_access_tskv_part ENGINE = Distributed('{cluster}', logs, _mail_web_api_access_tskv_part, rand());


CREATE TABLE IF NOT EXISTS logs._mail_subscriptions_access_tskv_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `timezone` LowCardinality(String),
    `status` UInt16,
    `protocol` LowCardinality(String),
    `method` LowCardinality(String),
    `request` String CODEC(ZSTD(7)),
    `referer` String CODEC(ZSTD(7)),
    `cookies` String CODEC(ZSTD(7)),
    `yandexuid` String MATERIALIZED extract(cookies, 'yandexuid=(\\d+)') CODEC(ZSTD(7)),
    `user_agent` String CODEC(ZSTD(7)),
    `vhost` String CODEC(ZSTD(7)),
    `ip` String CODEC(ZSTD(7)),
    `x_forwarded_for` String CODEC(ZSTD(7)),
    `x_real_ip` String CODEC(ZSTD(7)),
    `ipv4` IPv4 MATERIALIZED if(isIPv4String(x_real_ip), IPv4StringToNum(x_real_ip), CAST(0, 'IPv4')),
    `ipv6` IPv6 MATERIALIZED if(isIPv4String(x_real_ip) OR isIPv6String(x_real_ip), x_real_ip, '::'),
    `upstream_addr` LowCardinality(String),
    `upstream_response_time` Float32,
    `upstream_status` UInt16,
    `request_id` String CODEC(ZSTD(7)),
    `request_length` UInt16,
    `bytes_sent` UInt16,
    `request_time` Float32,
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_subscriptions_access_tskv_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;

CREATE TABLE IF NOT EXISTS logs.subscriptions_access_tskv ON CLUSTER '{cluster}' AS logs._mail_subscriptions_access_tskv_part ENGINE = Distributed('{cluster}', logs, _mail_subscriptions_access_tskv_part, rand());


CREATE TABLE IF NOT EXISTS logs._mail_duffman_access_log_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `timezone` LowCardinality(String),
    `project` String CODEC(ZSTD(7)),
    `reason` String CODEC(ZSTD(7)),
    `name` String CODEC(ZSTD(7)),
    `method` String CODEC(ZSTD(7)),
    `redirect_to` String CODEC(ZSTD(7)),
    `size` String CODEC(ZSTD(7)),
    `error` String CODEC(ZSTD(7)),
    `error_type` String CODEC(ZSTD(7)),
    `user_agent` String CODEC(ZSTD(7)),
    `status` UInt16,
    `livetime` Float32,
    `request` String CODEC(ZSTD(7)),
    `host` String CODEC(ZSTD(7)),
    `version` String CODEC(ZSTD(7)),
    `uid` String CODEC(ZSTD(7)),
    `x_real_ip` String CODEC(ZSTD(7)),
    `x_request_id` String CODEC(ZSTD(7)),
    `x_original_uri` String CODEC(ZSTD(7)),
    `x_origin` String CODEC(ZSTD(7)),
    `request_id` String alias `x_request_id`,
    `url` String CODEC(ZSTD(7)),
    `unixtime` Int32,
    `params` String CODEC(ZSTD(7)),
    `message` String CODEC(ZSTD(7)),
    `time` Float32,
    `level` LowCardinality(String),
    `request_attempt` UInt16,
    `handle` String CODEC(ZSTD(7)),
    `qloud_path` String CODEC(ZSTD(7)),
    `tskv_format` String CODEC(ZSTD(7)),
    `api_method` String CODEC(ZSTD(7)),
    `api_status` String CODEC(ZSTD(7)),
    `stack` String CODEC(ZSTD(7)),
    `path` String CODEC(ZSTD(7)),
    `x_cors` String CODEC(ZSTD(7)),
    `response_code` UInt16,
    `response_body` String CODEC(ZSTD(7)),
    `yandexuid` String CODEC(ZSTD(7)),
    `_lb_extra_server` String CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_duffman_access_log_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;

CREATE TABLE IF NOT EXISTS logs.duffman_access_log ON CLUSTER '{cluster}' AS logs._mail_duffman_access_log_part ENGINE = Distributed('{cluster}', logs, _mail_duffman_access_log_part, rand());


CREATE TABLE IF NOT EXISTS logs._mail_duffman_http_log_local ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `timezone` LowCardinality(String),
    `unixtime` UInt32,
    `level` LowCardinality(String),
    `reason` LowCardinality(String),
    `x_real_ip` String CODEC(ZSTD(7)),
    `x_request_id` String CODEC(ZSTD(7)),
    `request_id` String alias `x_request_id`,
    `host` String CODEC(ZSTD(7)),
    `status` UInt16,
    `request_time` UInt32,
    `sent` UInt32,
    `received` UInt32,
    `url` String CODEC(ZSTD(7)),
    `method` String CODEC(ZSTD(7)),
    `headers` String DEFAULT '{}' CODEC(ZSTD(7)),
    `uid` String CODEC(ZSTD(7)),
    `message` String CODEC(ZSTD(7)),
    `project` String CODEC(ZSTD(7)),
    `qloud_path` String CODEC(ZSTD(7)),
    `_lb_extra_server` String CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_duffman_http_log_local', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;

CREATE TABLE IF NOT EXISTS logs.duffman_http_log ON CLUSTER '{cluster}' AS logs._mail_duffman_http_log_local ENGINE = Distributed('{cluster}', logs, _mail_duffman_http_log_local, rand());


CREATE TABLE IF NOT EXISTS logs._mail_duffman_master_log_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `timezone` LowCardinality(String),
    `unixtime` UInt32,
    `level` LowCardinality(String),
    `reason` LowCardinality(String),
    `x_request_id` String CODEC(ZSTD(7)),
    `request_id` String alias `x_request_id`,
    `message` String CODEC(ZSTD(7)),
    `url` String CODEC(ZSTD(7)),
    `stack` String CODEC(ZSTD(7)),
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_duffman_master_log_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;

CREATE TABLE IF NOT EXISTS logs.duffman_master_log ON CLUSTER '{cluster}' AS logs._mail_duffman_master_log_part ENGINE = Distributed('{cluster}', logs, _mail_duffman_master_log_part, rand());


CREATE TABLE IF NOT EXISTS logs._mail_duffman_client_log_local ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`_timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` alias `_timestamp`,
    `timezone` LowCardinality(String) CODEC(ZSTD(7)),
    `unixtime` UInt32,
    `action` LowCardinality(String) CODEC(ZSTD(7)),
    `area` LowCardinality(String) CODEC(ZSTD(7)),
    `autocomplete_request_id` String CODEC(ZSTD(7)),
    `block` LowCardinality(String) CODEC(ZSTD(7)),
    `browser_notify_requested` LowCardinality(String) CODEC(ZSTD(7)),
    `client_timestamp` String CODEC(ZSTD(7)),
    `client` LowCardinality(String) CODEC(ZSTD(7)),
    `clientVer` LowCardinality(String) CODEC(ZSTD(7)),
    `close_reason` LowCardinality(String) CODEC(ZSTD(7)),
    `_date` String CODEC(ZSTD(7)),
    `draft_id` String CODEC(ZSTD(7)),
    `duration` UInt32,
    `eexp` String CODEC(ZSTD(7)),
    `errorCode` LowCardinality(String) CODEC(ZSTD(7)),
    `event` LowCardinality(String) CODEC(ZSTD(7)),
    `EventValue` String CODEC(ZSTD(7)),
    `fid` String CODEC(ZSTD(7)),
    `flow` LowCardinality(String) CODEC(ZSTD(7)),
    `foldersTabsEnabled` String CODEC(ZSTD(7)),
    `freeze` String CODEC(ZSTD(7)),
    `handler` LowCardinality(String) CODEC(ZSTD(7)),
    `i` String CODEC(ZSTD(7)),
    `id` String CODEC(ZSTD(7)),
    `ids` String CODEC(ZSTD(7)),
    `item` String CODEC(ZSTD(7)),
    `items` String CODEC(ZSTD(7)),
    `level` LowCardinality(String) CODEC(ZSTD(7)),
    `lifetime` String CODEC(ZSTD(7)),
    `message` String CODEC(ZSTD(7)),
    `mid` String CODEC(ZSTD(7)),
    `mids` String CODEC(ZSTD(7)),
    `name` LowCardinality(String) CODEC(ZSTD(7)),
    `params` String CODEC(ZSTD(7)),
    `path` String CODEC(ZSTD(7)),
    `reason` String CODEC(ZSTD(7)),
    `request_time` String CODEC(ZSTD(7)),
    `saved` LowCardinality(String) CODEC(ZSTD(7)),
    `scenario` String CODEC(ZSTD(7)),
    `session_id` String CODEC(ZSTD(7)),
    `sessionLifetime` Int32,
    `show_v1` LowCardinality(String) CODEC(ZSTD(7)),
    `show_v2` LowCardinality(String) CODEC(ZSTD(7)),
    `slow` String CODEC(ZSTD(7)),
    `statId` String CODEC(ZSTD(7)),
    `status` LowCardinality(String) CODEC(ZSTD(7)),
    `step` LowCardinality(String) CODEC(ZSTD(7)),
    `tabId` LowCardinality(String) CODEC(ZSTD(7)),
    `text_length` String CODEC(ZSTD(7)),
    `total` String CODEC(ZSTD(7)),
    `type` LowCardinality(String) CODEC(ZSTD(7)),
    `uid` String CODEC(ZSTD(7)),
    `usedSmall` String CODEC(ZSTD(7)),
    `userAgent` String CODEC(ZSTD(7)),
    `usertimestamp` String CODEC(ZSTD(7)),
    `view` LowCardinality(String) CODEC(ZSTD(7)),
    `yandexuid` String CODEC(ZSTD(7)),
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_duffman_client_log_local', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, _timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;

CREATE TABLE IF NOT EXISTS logs.duffman_client_log ON CLUSTER '{cluster}' AS logs._mail_duffman_client_log_local ENGINE = Distributed('{cluster}', logs, _mail_duffman_client_log_local, rand());
