CREATE TABLE IF NOT EXISTS logs._mail_mbody_production_nginx_access_log_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `timezone` LowCardinality(String),
    `status` UInt16,
    `protocol` LowCardinality(String),
    `method` LowCardinality(String),
    `request` String CODEC(ZSTD(7)),
    `referer` String CODEC(ZSTD(7)),
    `cookies` String CODEC(ZSTD(7)),
    `user_agent` String CODEC(ZSTD(7)),
    `vhost` String CODEC(ZSTD(7)),
    `ip` String CODEC(ZSTD(7)),
    `x_forwarded_for` String CODEC(ZSTD(7)),
    `x_real_ip` String CODEC(ZSTD(7)),
    `upstream_addr` LowCardinality(String),
    `upstream_response_time` Float32,
    `upstream_status` UInt16,
    `request_id` String CODEC(ZSTD(7)),
    `request_length` UInt16,
    `bytes_sent` UInt16,
    `request_time` Float32,
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_mbody_production_nginx_access_log_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;


CREATE TABLE IF NOT EXISTS logs._mail_mbody_production_access_log_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `host` String CODEC(ZSTD(7)),
    `connection` String CODEC(ZSTD(7)),
    `ip` String CODEC(ZSTD(7)),
    `method` LowCardinality(String),
    `request` String CODEC(ZSTD(7)),
    `status_code` UInt16,
    `referer` String CODEC(ZSTD(7)),
    `user_agent` String CODEC(ZSTD(7)),
    `cookies` String CODEC(ZSTD(7)),
    `forwarded_for` String CODEC(ZSTD(7)),
    `secure` LowCardinality(String),
    `y_context` String CODEC(ZSTD(7)),
    `profiler_exec` Float32,
    `profiler_preprocess` Float32,
    `profiler_total` Float32,
    `x_request_attempt` UInt16,
    `x_request_id` String CODEC(ZSTD(7)),
    `request_id` String alias `x_request_id`,
    `x_request_timeout` UInt32,
    `cookiesforwarded_for` String CODEC(ZSTD(7)),
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_mbody_production_access_log_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;


CREATE TABLE IF NOT EXISTS logs._mail_mbody_production_httpclient_log_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `session_id` String CODEC(ZSTD(7)),
    `y_context` String CODEC(ZSTD(7)),
    `host` String CODEC(ZSTD(7)),
    `port` UInt16,
    `uri` String CODEC(ZSTD(7)),
    `status` UInt16,
    `resolve_time` Float32,
    `connect_time` Float32,
    `tls_time` Float32,
    `total_time` Float32,
    `error` String CODEC(ZSTD(7)),
    `bytes_out` UInt32,
    `bytes_in` UInt32,
    `attempt` UInt16,
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_mbody_production_httpclient_log_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;



CREATE TABLE IF NOT EXISTS logs._mail_mbody_production_mbody_log_local ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`_timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` alias `_timestamp`,
    `timestamp_original` String CODEC(ZSTD(7)),
    `unixtime` UInt32,
    `thread` String CODEC(ZSTD(7)),
    `level` LowCardinality(String),
    `request_id` String CODEC(ZSTD(7)),
    `mid` String CODEC(ZSTD(7)),
    `hid` String CODEC(ZSTD(7)),
    `macs_message` String CODEC(ZSTD(7)),
    `macs_method` String CODEC(ZSTD(7)),
    `where_name` LowCardinality(String) CODEC(ZSTD(7)),
    `strategy_name` LowCardinality(String) CODEC(ZSTD(7)),
    `message` LowCardinality(String) CODEC(ZSTD(7)),
    `error_code.category` LowCardinality(String) CODEC(ZSTD(7)),
    `error_code.value` String CODEC(ZSTD(7)),
    `error_code.message` String CODEC(ZSTD(7)),
    `exception.type` String CODEC(ZSTD(7)),
    `exception.what` String CODEC(ZSTD(7)),
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_mbody_production_mbody_log_local', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, _timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;






CREATE TABLE IF NOT EXISTS logs._mail_mbody_corp_nginx_access_log_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `timezone` LowCardinality(String),
    `status` UInt16,
    `protocol` LowCardinality(String),
    `method` LowCardinality(String),
    `request` String CODEC(ZSTD(7)),
    `referer` String CODEC(ZSTD(7)),
    `cookies` String CODEC(ZSTD(7)),
    `user_agent` String CODEC(ZSTD(7)),
    `vhost` String CODEC(ZSTD(7)),
    `ip` String CODEC(ZSTD(7)),
    `x_forwarded_for` String CODEC(ZSTD(7)),
    `x_real_ip` String CODEC(ZSTD(7)),
    `upstream_addr` LowCardinality(String),
    `upstream_response_time` Float32,
    `upstream_status` UInt16,
    `request_id` String CODEC(ZSTD(7)),
    `request_length` UInt16,
    `bytes_sent` UInt16,
    `request_time` Float32,
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_mbody_corp_nginx_access_log_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;


CREATE TABLE IF NOT EXISTS logs._mail_mbody_corp_access_log_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `host` String CODEC(ZSTD(7)),
    `connection` String CODEC(ZSTD(7)),
    `ip` String CODEC(ZSTD(7)),
    `method` LowCardinality(String),
    `request` String CODEC(ZSTD(7)),
    `status_code` UInt16,
    `referer` String CODEC(ZSTD(7)),
    `user_agent` String CODEC(ZSTD(7)),
    `cookies` String CODEC(ZSTD(7)),
    `forwarded_for` String CODEC(ZSTD(7)),
    `secure` LowCardinality(String),
    `y_context` String CODEC(ZSTD(7)),
    `profiler_exec` Float32,
    `profiler_preprocess` Float32,
    `profiler_total` Float32,
    `x_request_attempt` UInt16,
    `x_request_id` String CODEC(ZSTD(7)),
    `request_id` String alias `x_request_id`,
    `x_request_timeout` UInt32,
    `cookiesforwarded_for` String CODEC(ZSTD(7)),
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_mbody_corp_access_log_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;



CREATE TABLE IF NOT EXISTS logs._mail_mbody_corp_httpclient_log_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `session_id` String CODEC(ZSTD(7)),
    `y_context` String CODEC(ZSTD(7)),
    `host` String CODEC(ZSTD(7)),
    `port` UInt16,
    `uri` String CODEC(ZSTD(7)),
    `status` UInt16,
    `resolve_time` Float32,
    `connect_time` Float32,
    `tls_time` Float32,
    `total_time` Float32,
    `error` String CODEC(ZSTD(7)),
    `bytes_out` UInt32,
    `bytes_in` UInt32,
    `attempt` UInt16,
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_mbody_corp_httpclient_log_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;



CREATE TABLE IF NOT EXISTS logs._mail_mbody_corp_mbody_log_local ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`_timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` alias `_timestamp`,
    `timestamp_original` String CODEC(ZSTD(7)),
    `unixtime` UInt32,
    `thread` String CODEC(ZSTD(7)),
    `level` LowCardinality(String),
    `request_id` String CODEC(ZSTD(7)),
    `mid` String CODEC(ZSTD(7)),
    `hid` String CODEC(ZSTD(7)),
    `macs_message` String CODEC(ZSTD(7)),
    `macs_method` String CODEC(ZSTD(7)),
    `where_name` LowCardinality(String) CODEC(ZSTD(7)),
    `strategy_name` LowCardinality(String) CODEC(ZSTD(7)),
    `message` LowCardinality(String) CODEC(ZSTD(7)),
    `error_code.category` LowCardinality(String) CODEC(ZSTD(7)),
    `error_code.value` String CODEC(ZSTD(7)),
    `error_code.message` String CODEC(ZSTD(7)),
    `exception.type` String CODEC(ZSTD(7)),
    `exception.what` String CODEC(ZSTD(7)),
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_mbody_corp_mbody_log_local', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, _timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;



CREATE TABLE IF NOT EXISTS logs.mbody_production_nginx_access_log ON CLUSTER '{cluster}' AS logs._mail_mbody_production_nginx_access_log_part ENGINE = Distributed('{cluster}', logs, _mail_mbody_production_nginx_access_log_part, rand());

CREATE TABLE IF NOT EXISTS logs.mbody_production_access_log ON CLUSTER '{cluster}' AS logs._mail_mbody_production_access_log_part ENGINE = Distributed('{cluster}', logs, _mail_mbody_production_access_log_part, rand());

CREATE TABLE IF NOT EXISTS logs.mbody_production_httpclient_log ON CLUSTER '{cluster}' AS logs._mail_mbody_production_httpclient_log_part ENGINE = Distributed('{cluster}', logs, _mail_mbody_production_httpclient_log_part, rand());

CREATE TABLE IF NOT EXISTS logs.mbody_production_mbody_log ON CLUSTER '{cluster}' AS logs._mail_mbody_production_mbody_log_local ENGINE = Distributed('{cluster}', logs, _mail_mbody_production_mbody_log_local, rand());

CREATE TABLE IF NOT EXISTS logs.mbody_corp_nginx_access_log ON CLUSTER '{cluster}' AS logs._mail_mbody_corp_nginx_access_log_part ENGINE = Distributed('{cluster}', logs, _mail_mbody_corp_nginx_access_log_part, rand());

CREATE TABLE IF NOT EXISTS logs.mbody_corp_access_log ON CLUSTER '{cluster}' AS logs._mail_mbody_corp_access_log_part ENGINE = Distributed('{cluster}', logs, _mail_mbody_corp_access_log_part, rand());

CREATE TABLE IF NOT EXISTS logs.mbody_corp_httpclient_log ON CLUSTER '{cluster}' AS logs._mail_mbody_corp_httpclient_log_part ENGINE = Distributed('{cluster}', logs, _mail_mbody_corp_httpclient_log_part, rand());

CREATE TABLE IF NOT EXISTS logs.mbody_corp_mbody_log ON CLUSTER '{cluster}' AS logs._mail_mbody_corp_mbody_log_local ENGINE = Distributed('{cluster}', logs, _mail_mbody_corp_mbody_log_local, rand());
