CREATE TABLE IF NOT EXISTS logs._mail_notsolitesrv_production_access_log_local ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `host` String CODEC(ZSTD(7)),
    `connection` String CODEC(ZSTD(7)),
    `method` String CODEC(ZSTD(7)),
    `request` String CODEC(ZSTD(7)),
    `status_code` UInt16,
    `referer` String CODEC(ZSTD(7)),
    `user_agent` String CODEC(ZSTD(7)),
    `cookies` String CODEC(ZSTD(7)),
    `forwarded_for` String CODEC(ZSTD(7)),
    `secure` UInt8 CODEC(ZSTD(7)),
    `y_context` String CODEC(ZSTD(7)),
    `profiler_exec` Float32,
    `profiler_preprocess` Float32,
    `profiler_total` Float32,
    `x_request_attempt` UInt16,
    `x_request_timeout` UInt16,
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_notsolitesrv_production_access_log_local', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;


CREATE TABLE IF NOT EXISTS logs._mail_notsolitesrv_production_attach_log_local ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`_timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` alias `_timestamp`,
    `unixtime` UInt32,
    `uid` String CODEC(ZSTD(7)),
    `suid` String CODEC(ZSTD(7)),
    `mid` String CODEC(ZSTD(7)),
    `fidType` String CODEC(ZSTD(7)),
    `fidSpecType` String CODEC(ZSTD(7)),
    `hid` String CODEC(ZSTD(7)),
    `fileType` String CODEC(ZSTD(7)),
    `name` String CODEC(ZSTD(7)),
    `size` UInt32,
    `stid` String CODEC(ZSTD(7)),
    `sessionId` String CODEC(ZSTD(7)),
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_notsolitesrv_production_attach_log_local', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, _timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;


CREATE TABLE IF NOT EXISTS logs._mail_notsolitesrv_production_httpclient_log_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `session_id` String CODEC(ZSTD(7)),
    `y_context` String CODEC(ZSTD(7)),
    `host` String CODEC(ZSTD(7)),
    `port` UInt16,
    `uri` String CODEC(ZSTD(7)),
    `status` UInt16,
    `resolve_time` Float32,
    `connect_time` Float32,
    `tls_time` Float32,
    `total_time` Float32,
    `error` String CODEC(ZSTD(7)),
    `bytes_out` UInt32,
    `bytes_in` UInt32,
    `attempt` UInt16,
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_notsolitesrv_production_httpclient_log_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;


CREATE TABLE IF NOT EXISTS logs._mail_notsolitesrv_production_notsolitesrv_log_local ON CLUSTER '{cluster}'
(
    `date` Date MATERIALIZED toDate(`_timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` alias `_timestamp`,
    `unixtime` UInt32,
    `thread` String CODEC(ZSTD(7)),
    `level` String CODEC(ZSTD(7)),
    `uniq_id` String CODEC(ZSTD(7)),
    `connection_id` String CODEC(ZSTD(7)),
    `envelope_id` String CODEC(ZSTD(7)),
    `message` String CODEC(ZSTD(7)),
    `where_name` String CODEC(ZSTD(7)),
    `uid` String CODEC(ZSTD(7)),
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_notsolitesrv_production_notsolitesrv_log_local', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, _timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;


CREATE TABLE IF NOT EXISTS logs._mail_notsolitesrv_corp_access_log_local ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `host` String CODEC(ZSTD(7)),
    `connection` String CODEC(ZSTD(7)),
    `method` String CODEC(ZSTD(7)),
    `request` String CODEC(ZSTD(7)),
    `status_code` UInt16,
    `referer` String CODEC(ZSTD(7)),
    `user_agent` String CODEC(ZSTD(7)),
    `cookies` String CODEC(ZSTD(7)),
    `forwarded_for` String CODEC(ZSTD(7)),
    `secure` UInt8 CODEC(ZSTD(7)),
    `y_context` String CODEC(ZSTD(7)),
    `profiler_exec` Float32,
    `profiler_preprocess` Float32,
    `profiler_total` Float32,
    `x_request_attempt` UInt16,
    `x_request_timeout` UInt16,
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_notsolitesrv_corp_access_log_local', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;


CREATE TABLE IF NOT EXISTS logs._mail_notsolitesrv_corp_attach_log_local ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`_timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` alias `_timestamp`,
    `unixtime` UInt32,
    `uid` String CODEC(ZSTD(7)),
    `suid` String CODEC(ZSTD(7)),
    `mid` String CODEC(ZSTD(7)),
    `fidType` String CODEC(ZSTD(7)),
    `fidSpecType` String CODEC(ZSTD(7)),
    `hid` String CODEC(ZSTD(7)),
    `fileType` String CODEC(ZSTD(7)),
    `name` String CODEC(ZSTD(7)),
    `size` UInt32,
    `stid` String CODEC(ZSTD(7)),
    `sessionId` String CODEC(ZSTD(7)),
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_notsolitesrv_corp_attach_log_local', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, _timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;


CREATE TABLE IF NOT EXISTS logs._mail_notsolitesrv_corp_httpclient_log_local ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `session_id` String CODEC(ZSTD(7)),
    `y_context` String CODEC(ZSTD(7)),
    `host` String CODEC(ZSTD(7)),
    `port` UInt16,
    `uri` String CODEC(ZSTD(7)),
    `status` UInt16,
    `resolve_time` Float32,
    `connect_time` Float32,
    `tls_time` Float32,
    `total_time` Float32,
    `error` String CODEC(ZSTD(7)),
    `bytes_out` UInt32,
    `bytes_in` UInt32,
    `attempt` UInt16,
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_notsolitesrv_corp_httpclient_log_local', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;


CREATE TABLE IF NOT EXISTS logs._mail_notsolitesrv_corp_notsolitesrv_log_local ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`_timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` alias `_timestamp`,
    `unixtime` UInt32,
    `thread` String CODEC(ZSTD(7)),
    `level` String CODEC(ZSTD(7)),
    `uniq_id` String CODEC(ZSTD(7)),
    `connection_id` String CODEC(ZSTD(7)),
    `envelope_id` String CODEC(ZSTD(7)),
    `message` String CODEC(ZSTD(7)),
    `where_name` String CODEC(ZSTD(7)),
    `uid` String CODEC(ZSTD(7)),
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_notsolitesrv_corp_notsolitesrv_log_local', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, _timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;



CREATE TABLE IF NOT EXISTS logs.notsolitesrv_production_access_log ON CLUSTER '{cluster}' AS logs._mail_notsolitesrv_production_access_log_local ENGINE = Distributed('{cluster}', logs, _mail_notsolitesrv_production_access_log_local, rand());

CREATE TABLE IF NOT EXISTS logs.notsolitesrv_production_attach_log ON CLUSTER '{cluster}' AS logs._mail_notsolitesrv_production_attach_log_local ENGINE = Distributed('{cluster}', logs, _mail_notsolitesrv_production_attach_log_local, rand());

CREATE TABLE IF NOT EXISTS logs.notsolitesrv_production_httpclient_log ON CLUSTER '{cluster}' AS logs._mail_notsolitesrv_production_httpclient_log_part ENGINE = Distributed('{cluster}', logs, _mail_notsolitesrv_production_httpclient_log_part, rand());

CREATE TABLE IF NOT EXISTS logs.notsolitesrv_production_notsolitesrv_log ON CLUSTER '{cluster}' AS logs._mail_notsolitesrv_production_notsolitesrv_log_local ENGINE = Distributed('{cluster}', logs, _mail_notsolitesrv_production_notsolitesrv_log_local, rand());

CREATE TABLE IF NOT EXISTS logs.notsolitesrv_corp_access_log ON CLUSTER '{cluster}' AS logs._mail_notsolitesrv_corp_access_log_local ENGINE = Distributed('{cluster}', logs, _mail_notsolitesrv_corp_access_log_local, rand());

CREATE TABLE IF NOT EXISTS logs.notsolitesrv_corp_attach_log ON CLUSTER '{cluster}' AS logs._mail_notsolitesrv_corp_attach_log_local ENGINE = Distributed('{cluster}', logs, _mail_notsolitesrv_corp_attach_log_local, rand());

CREATE TABLE IF NOT EXISTS logs.notsolitesrv_corp_httpclient_log ON CLUSTER '{cluster}' AS logs._mail_notsolitesrv_corp_httpclient_log_local ENGINE = Distributed('{cluster}', logs, _mail_notsolitesrv_corp_httpclient_log_local, rand());

CREATE TABLE IF NOT EXISTS logs.notsolitesrv_corp_notsolitesrv_log ON CLUSTER '{cluster}' AS logs._mail_notsolitesrv_corp_notsolitesrv_log_local ENGINE = Distributed('{cluster}', logs, _mail_notsolitesrv_corp_notsolitesrv_log_local, rand());
