CREATE TABLE IF NOT EXISTS logs._mail_nwsmtp_corp_access_log_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `host` String CODEC(ZSTD(7)),
    `connection` String CODEC(ZSTD(7)),
    `ip` String CODEC(ZSTD(7)),
    `_ip` IPv6 MATERIALIZED if(isIPv4String(ip) OR isIPv6String(ip), ip, '::'),
    `method` String CODEC(ZSTD(7)),
    `request` String CODEC(ZSTD(7)),
    `status_code` UInt16,
    `referer` String CODEC(ZSTD(7)),
    `user_agent` String CODEC(ZSTD(7)),
    `cookies` String CODEC(ZSTD(7)),
    `forwarded_for` String CODEC(ZSTD(7)),
    `_forwarded_for` IPv6 MATERIALIZED if(isIPv4String(`forwarded_for`) OR isIPv6String(`forwarded_for`), `forwarded_for`, '::'),
    `secure` UInt8,
    `y_context` String CODEC(ZSTD(7)),
    `profiler_exec` Float32,
    `profiler_preprocess` Float32,
    `profiler_total` Float32,
    `x_request_attempt` UInt16,
    `x_request_timeout` UInt16,
    `x_request_id` String CODEC(ZSTD(7)),
    `request_id` String alias `x_request_id`,
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_nwsmtp_corp_access_log_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;



CREATE TABLE IF NOT EXISTS logs._mail_nwsmtp_corp_httpclient_log_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `session_id` String CODEC(ZSTD(7)),
    `y_context` String CODEC(ZSTD(7)),
    `host` String CODEC(ZSTD(7)),
    `port` UInt16,
    `uri` String CODEC(ZSTD(7)),
    `status` UInt16,
    `resolve_time` Float32,
    `connect_time` Float32,
    `tls_time` Float32,
    `total_time` Float32,
    `error` String CODEC(ZSTD(7)),
    `bytes_out` UInt32,
    `bytes_in` UInt32,
    `attempt` UInt16,
    `direction` LowCardinality(String) CODEC(ZSTD(7)),
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_nwsmtp_corp_httpclient_log_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;



CREATE TABLE IF NOT EXISTS logs._mail_nwsmtp_corp_nwsmtp_log_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `unixtime` UInt32,
    `thread` String CODEC(ZSTD(7)),
    `level` String CODEC(ZSTD(7)),
    `cluster_name` LowCardinality(String) CODEC(ZSTD(7)),
    `host` String CODEC(ZSTD(7)),
    `uniq_id` String CODEC(ZSTD(7)),
    `connection_id` String CODEC(ZSTD(7)),
    `envelope_id` String CODEC(ZSTD(7)),
    `where_name` LowCardinality(String) CODEC(ZSTD(7)),
    `message` String CODEC(ZSTD(7)),
    `direction` LowCardinality(String) CODEC(ZSTD(7)),
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_nwsmtp_corp_nwsmtp_log_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;



CREATE TABLE IF NOT EXISTS logs._mail_nwsmtp_production_access_log_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `host` String CODEC(ZSTD(7)),
    `connection` String CODEC(ZSTD(7)),
    `ip` String CODEC(ZSTD(7)),
    `_ip` IPv6 MATERIALIZED if(isIPv4String(ip) OR isIPv6String(ip), ip, '::'),
    `method` String CODEC(ZSTD(7)),
    `request` String CODEC(ZSTD(7)),
    `status_code` UInt16,
    `referer` String CODEC(ZSTD(7)),
    `user_agent` String CODEC(ZSTD(7)),
    `cookies` String CODEC(ZSTD(7)),
    `forwarded_for` String CODEC(ZSTD(7)),
    `_forwarded_for` IPv6 MATERIALIZED if(isIPv4String(`forwarded_for`) OR isIPv6String(`forwarded_for`), `forwarded_for`, '::'),
    `secure` UInt8,
    `y_context` String CODEC(ZSTD(7)),
    `profiler_exec` Float32,
    `profiler_preprocess` Float32,
    `profiler_total` Float32,
    `x_request_attempt` UInt16,
    `x_request_timeout` UInt16,
    `x_request_id` String CODEC(ZSTD(7)),
    `request_id` String alias `x_request_id`,
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_nwsmtp_production_access_log_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;




CREATE TABLE IF NOT EXISTS logs._mail_nwsmtp_production_httpclient_log_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `session_id` String CODEC(ZSTD(7)),
    `y_context` String CODEC(ZSTD(7)),
    `host` String CODEC(ZSTD(7)),
    `port` UInt16,
    `uri` String CODEC(ZSTD(7)),
    `status` UInt16,
    `resolve_time` Float32,
    `connect_time` Float32,
    `tls_time` Float32,
    `total_time` Float32,
    `error` String CODEC(ZSTD(7)),
    `bytes_out` UInt32,
    `bytes_in` UInt32,
    `attempt` UInt16,
    `direction` LowCardinality(String) CODEC(ZSTD(7)),
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_nwsmtp_production_httpclient_log_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;



CREATE TABLE IF NOT EXISTS logs._mail_nwsmtp_production_nwsmtp_log_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `unixtime` UInt32,
    `thread` String CODEC(ZSTD(7)),
    `level` String CODEC(ZSTD(7)),
    `cluster_name` LowCardinality(String) CODEC(ZSTD(7)),
    `host` String CODEC(ZSTD(7)),
    `uniq_id` String CODEC(ZSTD(7)),
    `connection_id` String CODEC(ZSTD(7)),
    `envelope_id` String CODEC(ZSTD(7)),
    `where_name` LowCardinality(String) CODEC(ZSTD(7)),
    `message` String CODEC(ZSTD(7)),
    `direction` LowCardinality(String) CODEC(ZSTD(7)),
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_nwsmtp_production_nwsmtp_log_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;



CREATE TABLE IF NOT EXISTS logs.nwsmtp_corp_access_log ON CLUSTER '{cluster}' AS logs._mail_nwsmtp_corp_access_log_part ENGINE = Distributed('{cluster}', logs, _mail_nwsmtp_corp_access_log_part, rand());

CREATE TABLE IF NOT EXISTS logs.nwsmtp_corp_httpclient_log ON CLUSTER '{cluster}' AS logs._mail_nwsmtp_corp_httpclient_log_part ENGINE = Distributed('{cluster}', logs, _mail_nwsmtp_corp_httpclient_log_part, rand());

CREATE TABLE IF NOT EXISTS logs.nwsmtp_corp_nwsmtp_log ON CLUSTER '{cluster}' AS logs._mail_nwsmtp_corp_nwsmtp_log_part ENGINE = Distributed('{cluster}', logs, _mail_nwsmtp_corp_nwsmtp_log_part, rand());

CREATE TABLE IF NOT EXISTS logs.nwsmtp_production_access_log ON CLUSTER '{cluster}' AS logs._mail_nwsmtp_production_access_log_part ENGINE = Distributed('{cluster}', logs, _mail_nwsmtp_production_access_log_part, rand());

CREATE TABLE IF NOT EXISTS logs.nwsmtp_production_httpclient_log ON CLUSTER '{cluster}' AS logs._mail_nwsmtp_production_httpclient_log_part ENGINE = Distributed('{cluster}', logs, _mail_nwsmtp_production_httpclient_log_part, rand());

CREATE TABLE IF NOT EXISTS logs.nwsmtp_production_nwsmtp_log ON CLUSTER '{cluster}' AS logs._mail_nwsmtp_production_nwsmtp_log_part ENGINE = Distributed('{cluster}', logs, _mail_nwsmtp_production_nwsmtp_log_part, rand());
