CREATE TABLE IF NOT EXISTS logs._mail_sendbernar_production_nginx_access_log_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `timezone` LowCardinality(String),
    `status` UInt16,
    `protocol` LowCardinality(String),
    `method` LowCardinality(String),
    `request` String CODEC(ZSTD(7)),
    `referer` String CODEC(ZSTD(7)),
    `cookies` String CODEC(ZSTD(7)),
    `user_agent` String CODEC(ZSTD(7)),
    `vhost` String CODEC(ZSTD(7)),
    `ip` String CODEC(ZSTD(7)),
    `x_forwarded_for` String CODEC(ZSTD(7)),
    `x_real_ip` String CODEC(ZSTD(7)),
    `upstream_addr` LowCardinality(String),
    `upstream_response_time` Float32,
    `upstream_status` UInt16,
    `request_id` String CODEC(ZSTD(7)),
    `request_length` UInt16,
    `bytes_sent` UInt16,
    `request_time` Float32,
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_sendbernar_production_nginx_access_log_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;


CREATE TABLE IF NOT EXISTS logs._mail_sendbernar_production_postargs_log_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`time`) CODEC(DoubleDelta, LZ4),
    `time` DateTime CODEC(DoubleDelta, LZ4),
    `timestamp` UInt32,
    `timezone` LowCardinality(String) CODEC(ZSTD(7)),
    `x_request_id` String CODEC(ZSTD(7)),
    `request_id` String alias `x_request_id`,
    `caller` LowCardinality(String),
    `captcha_type` LowCardinality(String) CODEC(ZSTD(7)),
    `current_time` UInt32,
    `from_mailbox` String CODEC(ZSTD(7)),
    `from_name` String CODEC(ZSTD(7)),
    `html` LowCardinality(String) CODEC(ZSTD(7)),
    `message_id` String CODEC(ZSTD(7)),
    `sc` String CODEC(ZSTD(7)),
    `source_mid` String CODEC(ZSTD(7)),
    `subj` String CODEC(ZSTD(7)),
    `text` String CODEC(ZSTD(7)),
    `to` String CODEC(ZSTD(7)),
    `uid` String CODEC(ZSTD(7)),
    `uploaded_attach_stids` String CODEC(ZSTD(7)),
    `v` String CODEC(ZSTD(7)),
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_sendbernar_production_postargs_log_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, time)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;



CREATE TABLE IF NOT EXISTS logs._mail_sendbernar_production_access_log_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `host` String CODEC(ZSTD(7)),
    `connection` String CODEC(ZSTD(7)),
    `ip` String CODEC(ZSTD(7)),
    `method` LowCardinality(String),
    `request` String CODEC(ZSTD(7)),
    `status_code` UInt16,
    `referer` String CODEC(ZSTD(7)),
    `user_agent` String CODEC(ZSTD(7)),
    `cookies` String CODEC(ZSTD(7)),
    `forwarded_for` String CODEC(ZSTD(7)),
    `secure` LowCardinality(String),
    `y_context` String CODEC(ZSTD(7)),
    `connection_id` String CODEC(ZSTD(7)),
    `profiler_exec` Float32,
    `profiler_preprocess` Float32,
    `profiler_total` Float32,
    `x_request_attempt` UInt16,
    `x_request_id` String CODEC(ZSTD(7)),
    `request_id` String alias `x_request_id`,
    `x_request_timeout` UInt16,
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_sendbernar_production_access_log_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;



CREATE TABLE IF NOT EXISTS logs._mail_sendbernar_production_http_log_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `unixtime` UInt32,
    `thread` String CODEC(ZSTD(7)),
    `level` LowCardinality(String) CODEC(ZSTD(7)),
    `uid` String CODEC(ZSTD(7)),
    `x_request_id` String CODEC(ZSTD(7)),
    `request_id` String alias `x_request_id`,
    `operation` String CODEC(ZSTD(7)),
    `action` String CODEC(ZSTD(7)),
    `try_n` UInt16,
    `elapsed` Float32,
    `connect_time` Float32,
    `body` String CODEC(ZSTD(7)),
    `http_code` UInt16,
    `call_status` String CODEC(ZSTD(7)),
    `request_status` String CODEC(ZSTD(7)),
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_sendbernar_production_http_log_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;



CREATE TABLE IF NOT EXISTS logs._mail_sendbernar_production_metrics_log_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `unixtime` UInt32,
    `thread` String CODEC(ZSTD(7)),
    `level` LowCardinality(String) CODEC(ZSTD(7)),
    `uid` String CODEC(ZSTD(7)),
    `x_request_id` String CODEC(ZSTD(7)),
    `request_id` String alias `x_request_id`,
    `version` String CODEC(ZSTD(7)),
    `type` LowCardinality(String) CODEC(ZSTD(7)),
    `value` String CODEC(ZSTD(7)),
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_sendbernar_production_metrics_log_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;



CREATE TABLE IF NOT EXISTS logs._mail_sendbernar_production_httpclient_log_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `session_id` String CODEC(ZSTD(7)),
    `x_request_id` String CODEC(ZSTD(7)),
    `request_id` String alias `x_request_id`,
    `host` String CODEC(ZSTD(7)),
    `port` UInt16,
    `uri` String CODEC(ZSTD(7)),
    `status` UInt16,
    `resolve_time` Float32,
    `connect_time` Float32,
    `tls_time` Float32,
    `total_time` Float32,
    `error` String CODEC(ZSTD(7)),
    `bytes_out` UInt32,
    `bytes_in` UInt32,
    `attempt` UInt16,
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_sendbernar_production_httpclient_log_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;



CREATE TABLE IF NOT EXISTS logs._mail_sendbernar_production_sendbernar_log_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `unixtime` UInt32,
    `thread` String CODEC(ZSTD(7)),
    `level` LowCardinality(String),
    `uid` String CODEC(ZSTD(7)),
    `x_request_id` String CODEC(ZSTD(7)),
    `request_id` String alias `x_request_id`,
    `where_name` String CODEC(ZSTD(7)),
    `message` String CODEC(ZSTD(7)),
    `body` String CODEC(ZSTD(7)),
    `attach_size` UInt32,
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_sendbernar_production_sendbernar_log_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;






CREATE TABLE IF NOT EXISTS logs._mail_sendbernar_intranet_production_nginx_access_log_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `timezone` LowCardinality(String),
    `status` UInt16,
    `protocol` LowCardinality(String),
    `method` LowCardinality(String),
    `request` String CODEC(ZSTD(7)),
    `referer` String CODEC(ZSTD(7)),
    `cookies` String CODEC(ZSTD(7)),
    `user_agent` String CODEC(ZSTD(7)),
    `vhost` String CODEC(ZSTD(7)),
    `ip` String CODEC(ZSTD(7)),
    `x_forwarded_for` String CODEC(ZSTD(7)),
    `x_real_ip` String CODEC(ZSTD(7)),
    `upstream_addr` LowCardinality(String),
    `upstream_response_time` Float32,
    `upstream_status` UInt16,
    `request_id` String CODEC(ZSTD(7)),
    `request_length` UInt16,
    `bytes_sent` UInt16,
    `request_time` Float32,
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_sendbernar_intranet_production_nginx_access_log_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;



CREATE TABLE IF NOT EXISTS logs._mail_sendbernar_intranet_production_postargs_log_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`time`) CODEC(DoubleDelta, LZ4),
    `time` DateTime CODEC(DoubleDelta, LZ4),
    `timestamp` UInt32,
    `timezone` LowCardinality(String) CODEC(ZSTD(7)),
    `x_request_id` String CODEC(ZSTD(7)),
    `request_id` String alias `x_request_id`,
    `caller` LowCardinality(String),
    `captcha_type` LowCardinality(String) CODEC(ZSTD(7)),
    `current_time` UInt32,
    `from_mailbox` String CODEC(ZSTD(7)),
    `from_name` String CODEC(ZSTD(7)),
    `html` LowCardinality(String) CODEC(ZSTD(7)),
    `message_id` String CODEC(ZSTD(7)),
    `sc` String CODEC(ZSTD(7)),
    `source_mid` String CODEC(ZSTD(7)),
    `subj` String CODEC(ZSTD(7)),
    `text` String CODEC(ZSTD(7)),
    `to` String CODEC(ZSTD(7)),
    `uid` String CODEC(ZSTD(7)),
    `uploaded_attach_stids` String CODEC(ZSTD(7)),
    `v` String CODEC(ZSTD(7)),
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_sendbernar_intranet_production_postargs_log_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, time)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;



CREATE TABLE IF NOT EXISTS logs._mail_sendbernar_intranet_production_access_log_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `host` String CODEC(ZSTD(7)),
    `connection` String CODEC(ZSTD(7)),
    `ip` String CODEC(ZSTD(7)),
    `method` LowCardinality(String),
    `request` String CODEC(ZSTD(7)),
    `status_code` UInt16,
    `referer` String CODEC(ZSTD(7)),
    `user_agent` String CODEC(ZSTD(7)),
    `cookies` String CODEC(ZSTD(7)),
    `forwarded_for` String CODEC(ZSTD(7)),
    `secure` LowCardinality(String),
    `y_context` String CODEC(ZSTD(7)),
    `connection_id` String CODEC(ZSTD(7)),
    `profiler_exec` Float32,
    `profiler_preprocess` Float32,
    `profiler_total` Float32,
    `x_request_attempt` UInt16,
    `x_request_id` String CODEC(ZSTD(7)),
    `request_id` String alias `x_request_id`,
    `x_request_timeout` UInt16,
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_sendbernar_intranet_production_access_log_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;



CREATE TABLE IF NOT EXISTS logs._mail_sendbernar_intranet_production_http_log_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `unixtime` UInt32,
    `thread` String CODEC(ZSTD(7)),
    `level` LowCardinality(String) CODEC(ZSTD(7)),
    `uid` String CODEC(ZSTD(7)),
    `x_request_id` String CODEC(ZSTD(7)),
    `request_id` String alias `x_request_id`,
    `operation` String CODEC(ZSTD(7)),
    `action` String CODEC(ZSTD(7)),
    `try_n` UInt16,
    `elapsed` Float32,
    `connect_time` Float32,
    `body` String CODEC(ZSTD(7)),
    `http_code` UInt16,
    `call_status` String CODEC(ZSTD(7)),
    `request_status` String CODEC(ZSTD(7)),
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_sendbernar_intranet_production_http_log_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;



CREATE TABLE IF NOT EXISTS logs._mail_sendbernar_intranet_production_metrics_log_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `unixtime` UInt32,
    `thread` String CODEC(ZSTD(7)),
    `level` LowCardinality(String) CODEC(ZSTD(7)),
    `uid` String CODEC(ZSTD(7)),
    `x_request_id` String CODEC(ZSTD(7)),
    `request_id` String alias `x_request_id`,
    `version` String CODEC(ZSTD(7)),
    `type` LowCardinality(String) CODEC(ZSTD(7)),
    `value` String CODEC(ZSTD(7)),
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_sendbernar_intranet_production_metrics_log_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;



CREATE TABLE IF NOT EXISTS logs._mail_sendbernar_intranet_production_httpclient_log_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `session_id` String CODEC(ZSTD(7)),
    `x_request_id` String CODEC(ZSTD(7)),
    `request_id` String alias `x_request_id`,
    `host` String CODEC(ZSTD(7)),
    `port` UInt16,
    `uri` String CODEC(ZSTD(7)),
    `status` UInt16,
    `resolve_time` Float32,
    `connect_time` Float32,
    `tls_time` Float32,
    `total_time` Float32,
    `error` String CODEC(ZSTD(7)),
    `bytes_out` UInt32,
    `bytes_in` UInt32,
    `attempt` UInt16,
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_sendbernar_intranet_production_httpclient_log_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;



CREATE TABLE IF NOT EXISTS logs._mail_sendbernar_intranet_production_sendbernar_log_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `unixtime` UInt32,
    `thread` String CODEC(ZSTD(7)),
    `level` LowCardinality(String),
    `uid` String CODEC(ZSTD(7)),
    `x_request_id` String CODEC(ZSTD(7)),
    `request_id` String alias `x_request_id`,
    `where_name` String CODEC(ZSTD(7)),
    `message` String CODEC(ZSTD(7)),
    `body` String CODEC(ZSTD(7)),
    `attach_size` UInt32,
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_sendbernar_intranet_production_sendbernar_log_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;



CREATE TABLE IF NOT EXISTS logs.sendbernar_production_nginx_access_log ON CLUSTER '{cluster}' AS logs._mail_sendbernar_production_nginx_access_log_part ENGINE = Distributed('{cluster}', logs, _mail_sendbernar_production_nginx_access_log_part, rand());

CREATE TABLE IF NOT EXISTS logs.sendbernar_production_postargs_log ON CLUSTER '{cluster}' AS logs._mail_sendbernar_production_postargs_log_part ENGINE = Distributed('{cluster}', logs, _mail_sendbernar_production_postargs_log_part, rand());

CREATE TABLE IF NOT EXISTS logs.sendbernar_production_access_log ON CLUSTER '{cluster}' AS logs._mail_sendbernar_production_access_log_part ENGINE = Distributed('{cluster}', logs, _mail_sendbernar_production_access_log_part, rand());

CREATE TABLE IF NOT EXISTS logs.sendbernar_production_http_log ON CLUSTER '{cluster}' AS logs._mail_sendbernar_production_http_log_part ENGINE = Distributed('{cluster}', logs, _mail_sendbernar_production_http_log_part, rand());

CREATE TABLE IF NOT EXISTS logs.sendbernar_production_metrics_log ON CLUSTER '{cluster}' AS logs._mail_sendbernar_production_metrics_log_part ENGINE = Distributed('{cluster}', logs, _mail_sendbernar_production_metrics_log_part, rand());

CREATE TABLE IF NOT EXISTS logs.sendbernar_production_httpclient_log ON CLUSTER '{cluster}' AS logs._mail_sendbernar_production_httpclient_log_part ENGINE = Distributed('{cluster}', logs, _mail_sendbernar_production_httpclient_log_part, rand());

CREATE TABLE IF NOT EXISTS logs.sendbernar_production_sendbernar_log ON CLUSTER '{cluster}' AS logs._mail_sendbernar_production_sendbernar_log_part ENGINE = Distributed('{cluster}', logs, _mail_sendbernar_production_sendbernar_log_part, rand());

CREATE TABLE IF NOT EXISTS logs.sendbernar_corp_nginx_access_log ON CLUSTER '{cluster}' AS logs._mail_sendbernar_intranet_production_nginx_access_log_part ENGINE = Distributed('{cluster}', logs, _mail_sendbernar_intranet_production_nginx_access_log_part, rand());

CREATE TABLE IF NOT EXISTS logs.sendbernar_corp_postargs_log ON CLUSTER '{cluster}' AS logs._mail_sendbernar_intranet_production_postargs_log_part ENGINE = Distributed('{cluster}', logs, _mail_sendbernar_intranet_production_postargs_log_part, rand());

CREATE TABLE IF NOT EXISTS logs.sendbernar_corp_access_log ON CLUSTER '{cluster}' AS logs._mail_sendbernar_intranet_production_access_log_part ENGINE = Distributed('{cluster}', logs, _mail_sendbernar_intranet_production_access_log_part, rand());

CREATE TABLE IF NOT EXISTS logs.sendbernar_corp_http_log ON CLUSTER '{cluster}' AS logs._mail_sendbernar_intranet_production_http_log_part ENGINE = Distributed('{cluster}', logs, _mail_sendbernar_intranet_production_http_log_part, rand());

CREATE TABLE IF NOT EXISTS logs.sendbernar_corp_metrics_log ON CLUSTER '{cluster}' AS logs._mail_sendbernar_intranet_production_metrics_log_part ENGINE = Distributed('{cluster}', logs, _mail_sendbernar_intranet_production_metrics_log_part, rand());

CREATE TABLE IF NOT EXISTS logs.sendbernar_corp_httpclient_log ON CLUSTER '{cluster}' AS logs._mail_sendbernar_intranet_production_httpclient_log_part ENGINE = Distributed('{cluster}', logs, _mail_sendbernar_intranet_production_httpclient_log_part, rand());

CREATE TABLE IF NOT EXISTS logs.sendbernar_corp_sendbernar_log ON CLUSTER '{cluster}' AS logs._mail_sendbernar_intranet_production_sendbernar_log_part ENGINE = Distributed('{cluster}', logs, _mail_sendbernar_intranet_production_sendbernar_log_part, rand());
