CREATE TABLE IF NOT EXISTS logs._tavern_prod_nginx_access_log ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `timezone` LowCardinality(String),
    `status` UInt16,
    `protocol` LowCardinality(String),
    `method` LowCardinality(String),
    `request` String CODEC(ZSTD(7)),
    `referer` String CODEC(ZSTD(7)),
    `cookies` String CODEC(ZSTD(7)),
    `yandexuid` String MATERIALIZED extract(cookies, 'yandexuid=(\\d+)') CODEC(ZSTD(7)),
    `emptyCookie` Boolean MATERIALIZED `cookies` = '-',
    `user_agent` String CODEC(ZSTD(7)),
    `vhost` String CODEC(ZSTD(7)),
    `ip` String CODEC(ZSTD(7)),
    `ipv4` IPv4 MATERIALIZED if(isIPv4String(ip), IPv4StringToNum(ip), CAST(0, 'IPv4')),
    `ipv6` IPv6 MATERIALIZED if(isIPv4String(ip) OR isIPv6String(ip), ip, '::'),
    `x_forwarded_for` String CODEC(ZSTD(7)),
    `x_real_ip` String CODEC(ZSTD(7)),
    `https` LowCardinality(String),
    `upstream_addr` LowCardinality(String),
    `upstream_response_time` String CODEC(ZSTD(7)),
    `upstream_status` String CODEC(ZSTD(7)),
    `upstream_addrs` Array(String) MATERIALIZED splitByString(' : ', `upstream_addr`),
    `upstream_response_times` Array(Float32) MATERIALIZED arrayMap(x -> toFloat32OrZero(x), splitByString(' : ', `upstream_response_time`)),
    `upstream_statuses` Array(UInt16) MATERIALIZED arrayMap(x -> toUInt16OrZero(x), splitByString(' : ', `upstream_status`)),
    `request_id` String CODEC(ZSTD(7)),
    `request_length` UInt16,
    `bytes_sent` UInt16,
    `request_time` Float32,
    `antirobot_status` LowCardinality(String) CODEC(ZSTD(7)),
    `_lb_extra_server` String CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_tavern_prod_nginx_access_log', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;


CREATE TABLE IF NOT EXISTS logs._tavern_prod_duffman_access_log_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `timezone` LowCardinality(String),
    `project` String CODEC(ZSTD(7)),
    `reason` String CODEC(ZSTD(7)),
    `name` String CODEC(ZSTD(7)),
    `method` String CODEC(ZSTD(7)),
    `redirect_to` String CODEC(ZSTD(7)),
    `size` String CODEC(ZSTD(7)),
    `error` String CODEC(ZSTD(7)),
    `error_type` String CODEC(ZSTD(7)),
    `user_agent` String CODEC(ZSTD(7)),
    `status` UInt16,
    `livetime` Float32,
    `request` String CODEC(ZSTD(7)),
    `host` String CODEC(ZSTD(7)),
    `version` String CODEC(ZSTD(7)),
    `uid` String CODEC(ZSTD(7)),
    `x_real_ip` String CODEC(ZSTD(7)),
    `x_request_id` String CODEC(ZSTD(7)),
    `x_original_uri` String CODEC(ZSTD(7)),
    `x_origin` String CODEC(ZSTD(7)),
    `request_id` String alias `x_request_id`,
    `url` String CODEC(ZSTD(7)),
    `unixtime` Int32,
    `params` String CODEC(ZSTD(7)),
    `message` String CODEC(ZSTD(7)),
    `time` Float32,
    `level` LowCardinality(String),
    `request_attempt` UInt16,
    `handle` String CODEC(ZSTD(7)),
    `qloud_path` String CODEC(ZSTD(7)),
    `tskv_format` String CODEC(ZSTD(7)),
    `stack` String CODEC(ZSTD(7)),
    `path` String CODEC(ZSTD(7)),
    `x_cors` String CODEC(ZSTD(7)),
    `response_code` UInt16,
    `response_body` String CODEC(ZSTD(7)),
    `yandexuid` String CODEC(ZSTD(7)),
    `_lb_extra_server` String CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_tavern_prod_duffman_access_log_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;


CREATE TABLE IF NOT EXISTS logs._tavernt_prod_duffman_http_log_local ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `timezone` LowCardinality(String),
    `unixtime` UInt32,
    `level` LowCardinality(String),
    `reason` LowCardinality(String),
    `x_real_ip` String CODEC(ZSTD(7)),
    `x_request_id` String CODEC(ZSTD(7)),
    `request_id` String alias `x_request_id`,
    `host` String CODEC(ZSTD(7)),
    `status` UInt16,
    `request_time` UInt32,
    `sent` UInt32,
    `received` UInt32,
    `url` String CODEC(ZSTD(7)),
    `method` String CODEC(ZSTD(7)),
    `headers` String DEFAULT '{}' CODEC(ZSTD(7)),
    `uid` String CODEC(ZSTD(7)),
    `message` String CODEC(ZSTD(7)),
    `project` String CODEC(ZSTD(7)),
    `qloud_path` String CODEC(ZSTD(7)),
    `_lb_extra_server` String CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_tavernt_prod_duffman_http_log_local', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;


CREATE TABLE IF NOT EXISTS logs.tavern_prod_nginx_access_log ON CLUSTER '{cluster}' AS logs._tavern_prod_nginx_access_log ENGINE = Distributed('{cluster}', logs, _tavern_prod_nginx_access_log, rand());
CREATE TABLE IF NOT EXISTS logs.tavern_prod_duffman_access_log ON CLUSTER '{cluster}' AS logs._tavern_prod_duffman_access_log_part ENGINE = Distributed('{cluster}', logs, _tavern_prod_duffman_access_log_part, rand());
CREATE TABLE IF NOT EXISTS logs.tavern_prod_duffman_http_log ON CLUSTER '{cluster}' AS logs._tavernt_prod_duffman_http_log_local ENGINE = Distributed('{cluster}', logs, _tavernt_prod_duffman_http_log_local, rand());
