CREATE TABLE IF NOT EXISTS logs._xivaserver_access_log_local ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `timezone` LowCardinality(String),
    `host` String CODEC(ZSTD(7)),
    `connection` String CODEC(ZSTD(7)),
    `ip` String CODEC(ZSTD(7)),
    `forwarded_for` String CODEC(ZSTD(7)),
    `x_forwarded_for` String CODEC(ZSTD(7)),
    `x_real_ip` String CODEC(ZSTD(7)),
    `_ip` IPv6 MATERIALIZED if(isIPv4String(ip) OR isIPv6String(ip), ip, '::'),
    `_forwarded_for` IPv6 MATERIALIZED if(isIPv4String(forwarded_for) OR isIPv6String(forwarded_for), forwarded_for, '::'),
    `_x_forwarded_for` IPv6 MATERIALIZED if(isIPv4String(x_forwarded_for) OR isIPv6String(x_forwarded_for), x_forwarded_for, '::'),
    `_x_real_ip` IPv6 MATERIALIZED if(isIPv4String(x_real_ip) OR isIPv6String(x_real_ip), x_real_ip, '::'),
    `method` LowCardinality(String),
    `request` String CODEC(ZSTD(7)),
    `status_code` UInt16,
    `referer` String CODEC(ZSTD(7)),
    `user_agent` String CODEC(ZSTD(7)),
    `cookies` String CODEC(ZSTD(7)),
    `yandexuid` String MATERIALIZED extract(cookies, 'yandexuid=(\\d+)') CODEC(ZSTD(7)),
    `secure` LowCardinality(String),
    `y_context` String CODEC(ZSTD(7)),
    `profiler_exec` Float32,
    `profiler_preprocess` Float32,
    `profiler_total` Float32,
    `profiler_passport_oauth` Float32,
    `profiler_passport_cookie` Float32,
    `service` LowCardinality(String) CODEC(ZSTD(7)),
    `_service` String MATERIALIZED if(empty(`service`), extract(request, '[&?]service=([a-zA-Z0-9\.-]+)'), `service`) CODEC(ZSTD(7)),
    `_client` String MATERIALIZED extract(`request`, '[&?]client=([a-zA-Z0-9\.-]+)') CODEC(ZSTD(7)),
    `_uid` String MATERIALIZED extract(`request`, '[?&]uid=([a-zA-Z0-9_\\-]+)') CODEC(ZSTD(7)),
    `_user` String MATERIALIZED extract(`request`, '[?&]user=([a-zA-Z0-9_\\-]+)') CODEC(ZSTD(7)),
    `socket_stats` String CODEC(ZSTD(7)),
    `token` String CODEC(ZSTD(7)),
    `tvm_src` UInt32,
    `tvm_src_name` String CODEC(ZSTD(7)),
    `x_request_attempt` UInt16,
    `x_request_timeout` UInt16,
    `x_request_id` String CODEC(ZSTD(7)),
    `request_id` String alias `x_request_id`,
    `sec_websocket_extensions` String CODEC(ZSTD(7)),
    `subscriber` String CODEC(ZSTD(7)),
    `error` String CODEC(ZSTD(7)),
    `x_bb_connectionid` String CODEC(ZSTD(7)),
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_xivaserver_access_log_local', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;

CREATE TABLE IF NOT EXISTS logs.xivaserver_access_log ON CLUSTER '{cluster}' AS logs._xivaserver_access_log_local ENGINE = Distributed('{cluster}', logs, _xivaserver_access_log_local, rand());


CREATE TABLE IF NOT EXISTS logs._xivaserver_log_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `timezone` LowCardinality(String) CODEC(ZSTD(7)),
    `send_context` String CODEC(ZSTD(7)),
    `subscription_id` String CODEC(ZSTD(7)),
    `transit_id` String CODEC(ZSTD(7)),
    `local_id` String CODEC(ZSTD(7)),
    `group` LowCardinality(String) CODEC(ZSTD(7)),
    `action` LowCardinality(String) CODEC(ZSTD(7)),
    `event` LowCardinality(String) CODEC(ZSTD(7)),
    `protocol_code` LowCardinality(String) CODEC(ZSTD(7)),
    `service` LowCardinality(String) CODEC(ZSTD(7)),
    `private_error` String CODEC(ZSTD(7)),
    `reqid` UInt32,
    `http_code` UInt16,
    `request_bytes` UInt32,
    `response_bytes` UInt32,
    `backend_time` Float32,
    `connection` String CODEC(ZSTD(7)),
    `subscriber` String CODEC(ZSTD(7)),
    `uid` String CODEC(ZSTD(7)),
    `mid` String CODEC(ZSTD(7)),
    `client` String CODEC(ZSTD(7)),
    `filter` String CODEC(ZSTD(7)),
    `session` String CODEC(ZSTD(7)),
    `info` String CODEC(ZSTD(7)),
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_xivaserver_log_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;

CREATE TABLE IF NOT EXISTS logs.xivaserver_log ON CLUSTER '{cluster}' AS logs._xivaserver_log_part ENGINE = Distributed('{cluster}', logs, _xivaserver_log_part, rand());



CREATE TABLE IF NOT EXISTS logs._mailpusher_access_log_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `timezone` LowCardinality(String) CODEC(ZSTD(7)),
    `host` LowCardinality(String) CODEC(ZSTD(7)),
    `connection` String CODEC(ZSTD(7)),
    `method` LowCardinality(String) CODEC(ZSTD(7)),
    `request` String CODEC(ZSTD(7)),
    `_uid` MATERIALIZED extract(`request`, 'uid=(\\d+)') CODEC(ZSTD(7)),
    `_events_in_batch` MATERIALIZED extract(`request`, 'events_in_batch=(\\d+)'),
    `status_code` UInt16,
    `referer` String CODEC(ZSTD(7)),
    `user_agent` String CODEC(ZSTD(7)),
    `cookies` String CODEC(ZSTD(7)),
    `forwarded_for` String CODEC(ZSTD(7)),
    `secure` UInt16,
    `y_context` String CODEC(ZSTD(7)),
    `processed` UInt16,
    `profiler_exec` Float32,
    `profiler_preprocess` Float32,
    `profiler_total` Float32,
    `result_code` UInt16,
    `result_message` String CODEC(ZSTD(7)),
    `sup_id` String CODEC(ZSTD(7)),
    `x_request_attempt` UInt16,
    `x_request_timeout` UInt16,
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mailpusher_access_log_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;

CREATE TABLE IF NOT EXISTS logs.mailpusher_access_log ON CLUSTER '{cluster}' AS logs._mailpusher_access_log_part ENGINE = Distributed('{cluster}', logs, _mailpusher_access_log_part, rand());



CREATE TABLE IF NOT EXISTS logs._mailpusher_typed_log_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `timezone` LowCardinality(String) CODEC(ZSTD(7)),
    `action` String CODEC(ZSTD(7)),
    `status` LowCardinality(String) CODEC(ZSTD(7)),
    `reason` LowCardinality(String) CODEC(ZSTD(7)),
    `context` String CODEC(ZSTD(7)),
    `counters_fetched` LowCardinality(String) CODEC(ZSTD(7)),
    `dbname` LowCardinality(String) CODEC(ZSTD(7)),
    `profiler_counters` Float32,
    `profiler_meta` Float32,
    `profiler_total` Float32,
    `profiler_xiva_list` Float32,
    `profiler_xiva_send` Float32,
    `uid` String CODEC(ZSTD(7)),
    `suid` String CODEC(ZSTD(7)),
    `avatar_fetched` LowCardinality(String) CODEC(ZSTD(7)),
    `cid` UInt32,
    `item_count` UInt32,
    `lag` UInt32,
    `meta_count` UInt32,
    `ts` UInt32,
    `transit_id` String CODEC(ZSTD(7)),
    `xiva_context` String CODEC(ZSTD(7)),
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mailpusher_typed_log_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;

CREATE TABLE IF NOT EXISTS logs.mailpusher_typed_log ON CLUSTER '{cluster}' AS logs._mailpusher_typed_log_part ENGINE = Distributed('{cluster}', logs, _mailpusher_typed_log_part, rand());



CREATE TABLE IF NOT EXISTS logs._xivamesh_httpout_log_part ON CLUSTER '{cluster}'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `timezone` LowCardinality(String) CODEC(ZSTD(7)),
    `session_id` String CODEC(ZSTD(7)),
    `y_context` String CODEC(ZSTD(7)),
    `host` LowCardinality(String) CODEC(ZSTD(7)),
    `port` UInt16,
    `uri` String CODEC(ZSTD(7)),
    `_uid` String MATERIALIZED extract(`uri`, 'uid=([a-z0-9]+)') CODEC(ZSTD(7)),
    `_service` String MATERIALIZED extract(`uri`, 'service=([a-zA-Z0-9-\.]+)') CODEC(ZSTD(7)),
    `_uidservice` String MATERIALIZED extract(`uri`, 'uidservice=([a-zA-Z0-9-\.]+)') CODEC(ZSTD(7)),
    `status` UInt16,
    `resolve_time` Float32,
    `connect_time` Float32,
    `tls_time` Float32,
    `total_time` Float32,
    `error` LowCardinality(String) CODEC(ZSTD(7)),
    `bytes_out` UInt32,
    `bytes_in` UInt32,
    `attempt` UInt16,
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_xivamesh_httpout_log_part', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;

CREATE TABLE IF NOT EXISTS logs.xivamesh_httpout_log ON CLUSTER '{cluster}' AS logs._xivamesh_httpout_log_part ENGINE = Distributed('{cluster}', logs, _xivamesh_httpout_log_part, rand());
