## Dirty orange
Сервис для учений SRE-vteam, позволяющеий генерировать произвольное количество алертов, на которые должны реагировать дежурные. Название dirty orange - это гибрид
[Google DiRT](https://queue.acm.org/detail.cfm?id=2371516) и [annoying orange](https://en.wikipedia.org/wiki/Annoying_Orange).

### Как выглядит в проде
В контейнере живёт http-демон на 8080 порту с конфигурацией в /etc/dirty-orange.
Имеет единственную ручку /hey, которая:
- обходит хосты, перечисленные в peers в конфиге, и дёргает /hey у них
- обходит базы, перечисленные в databases в конфиге, и выполняет простой запрос
При любых ошибках пятисотит.

### Как собрать
На машине с докером выполнить
```
./build.sh
```

### Как проводить учения

Управление алертами производится утилитой alertctl. Алерты делятся на 2 типа: эмулирующие занятость дежурного на заданное количество времени и эмулирующие проблемы в контейнере, требующие диагностики и починки.
#### Алерты, эмулирующие занятность дежурного
Чтобы зажечь алерт первого типа, набрать
```
alertctl start <имя алерта> <сколько секунд займёт "починка">
```
Подразумевается, что, получив алерт, дежурный выполнит на тачке
```
alertctl fix <имя алерта>
```
и после этого не будет реагировать на другие алерты на время "починки".
Алерт потухнет сам, как только истечёт время на "починку".

#### Алерты, эмулирующие реальную проблему
##### unispace
```
alertctl start unispace [deleted]
```
создаст файл в случайном месте в /var, занимающий почти всё место на этом разделе.
Если передать опциональный аргумент deleted, будет запущен процесс, читающий файл, а сам файл будет удалён.

##### 5xx
У dirty-orange есть единственная ручка /hey, которая ходит в другой контейнер с dirty-orange в его ручку /hey.
Проверка на 5xx происходит каждые 30 секунд независимо от alertctl, поэтому ломать этот поход можно любым удобным координатору способом.
В настоящее время заскриптовано несколько таких способов:

| Имя | Что сделает |
| - | - |
| network | заблокирует с помощью ip6tables исходящий трафик из данного инстанса dirty-orange в тот контейнер, в который он ходит |
| dns | сломает резолвинг через подмену /etc/resolv.conf на ошибочный |
| pg_network | заблокирует хосты базы по iptables |
| pg_cert | сломает root-сертификат в цепочке, вызывая ошибку проверки сертификата при соединении |
| pg_pass_mode | выставит неприемлемые с точки зрения libpq права на .pgpass |
| pg_password | сломает содержимое .pgpass |
| pg_max_connections | стриггерит превышение лимита коннектов к базе от пользователя dirty-orange |

Чтобы сломать сервис одним из вышеуказанных способов, передайте имя способа следующим параметром alertctl после 5xx, например:
```
alertctl start 5xx dns
```


#### Как погасить непочиненный алерт
Чтобы руками погасить алерт любого типа прямо сейчас, выполнить
```
alertctl stop <имя алерта>
```
В течение 30 секунд сигнал, по которому строится алерт, должен получить значение 0. В случае алерта 5xx ошибки будут остановлены
вне зависимости от способа (network, dns).
