#!/bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

function ephemeral_log {
    rm -rf "/var/log/$1"
    mkdir -p "/ephemeral/logs/$1"
    ln -s "/ephemeral/logs/$1" /var/log/
}
function ephemeral_var {
    rm -rf "/var/$1"
    mkdir -p "/ephemeral/$1"
    ln -s "/ephemeral/$1" /var/
}

env | grep QLOUD >> /etc/environment

env=$QLOUD_ENVIRONMENT
app=$QLOUD_APPLICATION
user=$QLOUD_EXEC_USER

if ! id -u $user &>/dev/null; then
    adduser --system --disabled-password --group $user
    service procps restart
fi

ephemeral_log "$app"
ephemeral_var "$app"
mkdir -p "/var/$app/alerts"
mkdir -p "/var/$app/alert_timers"
chown -R -H $user:$user "/etc/$app"
chown -R -H $user:$user "/var/log/$app"
chown -R -H $user:$user "/home/$user"

chmod 644 /etc/cron.d/*
chmod 0600 /home/dirty-orange/.postgresql/root.crt
chmod 0600 /home/dirty-orange/.pgpass
chmod 755 /usr/bin/welcome && echo '/usr/bin/welcome' >> /root/.bashrc
ln -sf "/etc/$app/$env.yml" "/etc/$app/config.yml"

portoctl run self/sub_cron \
    respawn=true \
    isolate=false \
    command='/usr/sbin/cron -f'

portoctl run self/sub_main \
    respawn=true \
    isolate=false \
    user=$(id -u $user) \
    command="/usr/sbin/$app.py /etc/$app/config.yml"

portoctl run self/sub_unistat \
    respawn=true \
    isolate=false \
    command='/usr/sbin/unistat_daemon.py'

/bin/sleep infinity