#!/usr/bin/python3
# coding: utf-8

from http.server import HTTPServer, SimpleHTTPRequestHandler
import socket
import json
import os
from os.path import isfile, join
import collections

port = 11010

drills_flag_path = '/var/dirty-orange/drills'

def main():
    server = HTTPServerV6(('::', port), UnistatHandler)
    server.serve_forever()

class HTTPServerV6(HTTPServer):
    address_family = socket.AF_INET6

class UnistatHandler(SimpleHTTPRequestHandler):
    def do_GET(self):
        if self.path != '/unistat':
            self.send_response(404)
            return

        response_body = self.unistat_response_body()
        self.send_response(200)
        self.send_header('Content-type', 'text/json')
        self.end_headers()
        self.wfile.write(bytes(response_body, 'UTF-8'))

    def unistat_response_body(self):
        alert_values = self.read_alert_values('/var/dirty-orange/alerts')
        return json.dumps([ [a.name + '_aeee', float(a.value)] for a in alert_values ])

    def drills_enabled(self):
        return isfile(drills_flag_path)

    def read_alert_values(self, signal_dir):
        Alert = collections.namedtuple('Alert', ['name', 'value'])
        alerts = []
        for f_name in os.listdir(signal_dir):
            f_path = join(signal_dir, f_name)
            if isfile(f_path) and f_name[0] != '.':
                if self.drills_enabled():
                    with open(f_path, 'r') as f:
                        alerts.append(Alert(f_name, f.read()))
                else:
                    alerts.append(Alert(f_name, 0))
        return alerts


if __name__ == '__main__':
    main()
