peer_address="haughty-pear.$QLOUD_ENVIRONMENT.dirty-orange.mail.stable.qloud-d.yandex.net"
db_address="host=vla-xxgmbzz6dya5kuun.db.yandex.net,sas-ommek17z8j1rx2a4.db.yandex.net port=6432 sslmode=verify-full dbname=dirty-orange user=dirty-orange target_session_attrs=read-write"
resolv_file='/etc/resolv.conf'
resolv_dump_file='/tmp/resolv.conf.default'
resolve_fake_file='/tmp/resolv.conf.fake'
pgpass_path="/home/dirty-orange/.pgpass"
pgcert_path="/home/dirty-orange/.postgresql/root.crt"
bogus_cert='
-----BEGIN CERTIFICATE-----
MIIB+zCCAWQCCQCmwG53y9G4tjANBgkqhkiG9w0BAQUFADBCMQswCQYDVQQGEwJS
VTEVMBMGA1UEBwwMRGVmYXVsdCBDaXR5MRwwGgYDVQQKDBNEZWZhdWx0IENvbXBh
bnkgTHRkMB4XDTE0MDEyMzE2MjY0NFoXDTE1MDEyMzE2MjY0NFowQjELMAkGA1UE
BhMCUlUxFTATBgNVBAcMDERlZmF1bHQgQ2l0eTEcMBoGA1UECgwTRGVmYXVsdCBD
b21wYW55IEx0ZDCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAtKEdZKoYPYsb
fjj+Gv41cI08gb0M4h4B2bxU8dlpS0SsJo/H85UPx1eLAcBpLmMEuEjapUMWOiJ1
jPs3RfMmkhaUmFEV1sTjFfny5o3pBqahzsAsMEcdf1JNApTJ2GNYGaPG+TrJKBLm
ayqeRtxiCC0wg1zLVD5yzcxFUI/rC50CAwEAATANBgkqhkiG9w0BAQUFAAOBgQBc
u8MlfIHUpSulrMI+Y1Yqov4EaLLM9XGEEvQlWktOvqktTfsTzIAtg7Ms/2hZ4QvJ
QcDARc4STDM/SQYSDz2RDzgvG2vXHcvqkUFrDl3g1lhFYcfUu/MJmG52/dV0zw0H
cQAvBJljzSEHU/UXyX1qaxdguxmu3xKCybvJtABMYA==
-----END CERTIFICATE-----
'

function block_outgoing_ipv6_traffic()
{
    ip6tables -A OUTPUT -d "$1" -j DROP
}

function destroy_dns_resolver()
{
    cat $resolv_file > $resolv_dump_file && cat $resolve_fake_file > $resolv_file
}

function block_all_db_hosts()
{
    block_outgoing_ipv6_traffic "vla-xxgmbzz6dya5kuun.db.yandex.net"
    block_outgoing_ipv6_traffic "sas-ommek17z8j1rx2a4.db.yandex.net"
}

function inject_bogus_pg_cert()
{
    echo "$bogus_cert" > "$pgcert_path"
    portoctl restart app/sub_main
}

function scramble_pgpgass()
{
    while fgrep -q dirty-orange "$pgpass_path"; do
        sed -i "s/dirty-orange/$(random_word)/" "$pgpass_path"
    done
    sed -i "s/dirty-password/$(random_word)/" "$pgpass_path"
}

function start_pg_connection_hog()
{
    hog_query="SELECT pg_sleep(100500)"
    hog_name=$(random_word)_$(random_word)
    portoctl run "app/sub_$hog_name" \
        respawn=false \
        isolate=false \
        user=$(id -u dirty-orange) \
        command="psql -c '$hog_query' '$db_address'"
}

function returns_ok()
{
    path=$1
    curl --silent --fail --max-time 1 --output /dev/null "localhost:8080${path}"
}

function 5xx_start()
{
    cause=$1
    case "$cause" in
        network)  block_outgoing_ipv6_traffic "$peer_address";;
        dns)  destroy_dns_resolver;;
        pg_network) block_all_db_hosts;;
        pg_cert) inject_bogus_pg_cert;;
        pg_pass_mode) chmod a+r "$pgpass_path";;
        pg_password) scramble_pgpgass;;
        pg_max_connections) start_pg_connection_hog;;
        *)   echo "unknown 5xx cause: $1"; return 1;;
    esac
}

function 5xx_stop()
{

    if [ -f $resolv_dump_file ]; then
        cat $resolv_dump_file > $resolv_file
        rm -f $resolv_dump_file
    fi

    ip6tables -F
    wget "https://crls.yandex.net/allCAs.pem" -qO "$pgcert_path"
    chmod 0600 "$pgpass_path"
    killall -q psql || true
    echo '*:6432:dirty-orange:dirty-orange:dirty-password' > "$pgpass_path"
}

function 5xx_fix()
{
    if returns_ok /hey; then
        echo "You've fixed it! Service is replying 200 again."
    else
        echo "Nope, that's not enough.
            localhost:8080/hey suddenly started serving 500 instead of 200.
            It's your job to fix it.
            Look at the docs, look at the logs."
    fi
}
