### Что делает сервис
Компонент, выполняющий всю основную работу по учету подписок и отправке сообщений в правильный канал доставки.
#### API для подписок/отправок
Хабы объединены в группы по три машины (один шард), каждая группа обслуживает свой диапазон пользователей. У каждого шарда есть мастер и 2 слейва, выбирающихся по алгоритму [paxos](https://wiki.yandex-team.ru/nordsturm/modpaxos/).
Xivaserver, основной потребитель, определяет нужный шард на своей стороне и ходит напрямую в инстансы, используя постоянные DNS имена инстансов в Qloud. 
Для остальных (xivadba, logconsumer и для почтовых пушей в APNs) - направление запросов в правильный шард хаба осуществляется через L7 балансер. 

#### Очередь доставки
В сервисе есть умная очередь заданий вида "uid+service" (xtasks), фактически означающих: "по пользователю N в сервисе X есть работа". Задания выстраиваются в очередь и выдаются worker-ам. Worker - это отдельная корутина внутри процесса хаба. Каждый worker имеет имя, по которому отслеживаются его задания. Модули xtasks и worker обеспечивают надежную доставки с соблюдением порядка сообщений. Каждый шард хаба общается с другими в пределах кластера для централизованного контроля распределённой баз задач xtasks и согласования режима работы всего кластера. Основные каналы доставки нотификаций это callback, мобильные (xivamob) и websocket (xiva-server).

#### Callback
Каждое приложение, может подписать свой бэкенд на уведомления через HTTP вызовы - [Callback](https://console.push.yandex-team.ru/#api-reference-subscribe-url).
И пойдёт в этот бэкенд именно xivahub. В подписке, в базе, лежит url, который указали в подписке и хаб отправит нотификацию прямо в этот url. Например, IMAP работает именно по этому принципу.

### Импакт на пользователей от отключения сервиса
Сервисы не будут получать никакие уведомления - пуши на мобильные, пуши в браузере, мессенджер. Клиенты не смогут осуществлять подписки/отписки. В случае проблем с xtasks или xstore есть возможность ослабить гарантии по уникальности доставки ("тыква"). [Подробнее](https://wiki.yandex-team.ru/rtec/oncall/xiva/#vkljuchittykvunaxstoreprimassovyxoshibkaxlibonavremjarabotnabazax)

### Импакт остановки тачки/ДЦ
Может быть небольшой всплеск ошибок, если машина которую погасили была мастером в своем хабе.

### Особенности деплоя
Катим на первый шард хаба, смотрим на графики. При отсутствии проблем катим на остальные шарды хабы. Каждый шард это отдельный компонет в Qloud. 

### Критичные метрики
#### conveyfailed_perc
Процент не успешных отправок сообщений.

#### xivahub_percent500
Процент 500 кодов ответа.

### Куда ходит
#### xivamob (http_client)
Отправка пушей для браузера и мобильных облаков (APNS, FCM и другие) [Подробнее](https://a.yandex-team.ru/arc/trunk/arcadia/mail/sre/doc/xivamob.md).
#### xstore (cluster_pq)
Хранилище нотификаций, поступающих от сервисов. Представляет собой БД PostgreSQL в MDB. Подробнее про [cluster_pq](https://wiki.yandex-team.ru/yxiva/spec/hub/pgclient/) 
#### xtable (cluster_pq)
Хранилище таблицы персональных подписок и позиции доставки. Представляет собой БД PostgreSQL в MDB.
#### imap (http_client)
Подписывается по callback.
#### xivaserver (http_client)
Вебсокетные пуши. Клиент приносит пуш в API /v2/send в инстанс xiva-server X. Инстанс X приносит пуш в хаб. Хаб достает из базы подписку, в которой написано: вебсокет, установлен с инстансом сервера Y. И хаб несёт пуш в xiva-server инстанс Y в специальную ручку back api. Инстанс сервера Y находит в своём каталоге вебсокетов нужный и отправляет в него пуш.
#### leasemeta (ymod_lease)
Для выбора мастера среди тройки машин и хранения топологии кластера (json с указанием хостов машин).
