freeStyleJob('build-mail-base') {
    description('Сборка базового docker-образа для Почты')
    label('maildev')
    logRotator(-1, 10)
    parameters {
        choiceParam('LSB_RELEASE', ['trusty', 'bionic', 'focal'], 'Версия ubuntu')
    }
    parameters {
        stringParam('ARC_REVIEW', '', 'Ревью в Аркадии (опционально)')
    }
    wrappers {
        sshAgent('robot-gerrit-ssh-key')
        preBuildCleanup()
    }
    steps {
        shell('''
        svn cat svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/ya | python - clone; cd arcadia
        ya make --checkout -j0 mail/docker-images
        if [ ! -z ${ARC_REVIEW} ];then
            ya pr checkout -i ${ARC_REVIEW}
        fi
        cd mail/docker-images/mail-base
        bash docker-prepare.sh
        docker build --no-cache --pull --tag registry.yandex.net/mail/mail-base-${LSB_RELEASE}:latest --build-arg LSB_RELEASE=${LSB_RELEASE} .
        docker push registry.yandex.net/mail/mail-base-${LSB_RELEASE}:latest
        ''')
    }
}
