freeStyleJob('overbuild-docker') {
    description('Сборка docker образа с наложением статитки из репозитория')
    label('maildev')
    logRotator(-1, 10)
  	triggers {
        cron('H 3 * * *')
    }
    parameters {
        stringParam('NEW_TAG', '', 'Имя тега нового образа')
        stringParam('REVIEW_ID', '', 'review в Аркадии')
        stringParam('SRC_REGISTRY', '', 'Тег и версия образа в registry')
        stringParam('SRC_DIR', 'deploy', 'Каталог для копирования')
        stringParam('TARGET_DIR', '/', 'Путь назначения внутри образа')
        stringParam('ARCADIA_DIR', '', 'Путь до SRC_DIR в Аркадии')
    }
    wrappers {
        sshAgent('robot-gerrit-ssh-key')
        preBuildCleanup()
    }
    steps {
        shell('''
        mkdir -p arc && cd arc
        mkdir -p arcadia store
        arc mount -m arcadia/ -S store/
        cd arcadia
        arc pr checkout $REVIEW_ID
        cp mail/sre/jenkins-jobs/Dockerfile-overbuild $ARCADIA_DIR
        cp mail/sre/jenkins-jobs/overbuild_docker-prepare.sh $ARCADIA_DIR
        cd $ARCADIA_DIR
        bash overbuild_docker-prepare.sh $SRC_REGISTRY $SRC_DIR $TARGET_DIR
        docker build --no-cache --pull --tag $SRC_REGISTRY"-"$NEW_TAG -f Dockerfile-overbuild .
        docker push $SRC_REGISTRY"-"$NEW_TAG
        cd ~
        mount | grep arc | awk '{print "arc unmount "$3}' | bash
        ''')
    }
}
