# SPIHelper
Тул небольшой автоматизации по инцидентам и околоинцидентных вещей.

## Как работает
В main файле запускаются джобы, которые описаны в jobs и наследуются от базового класса BaseJob.
Задачи запускаются через apscheduler, настройки расписания задаются в конфиг файле, в секции с названием задачи.
Каждая джоба проверяет лок в locke.y-t (путь определяется в конфиг файле) и берет его на время выполнения задачи.

## Что делает
### FindSpproblem
Джоба по выявлению потенциальных SPProblem. Комоненты для которых ищем SPProblem задаются в конфиге, в разделе ```components```.
Для каждой компоненты загружаем из Warden инциденты за текущее ревью, в них находим связанные AI.
Сортируем, чтобы посчитать количество связанных инцидентов у каждого AI, если количество инцидентов больше или равно 2,
и к каждому инциденту не привязана SPProblem, то пишем комментарий в последний инцидент, о том что это возможно выделить в SPProblem.
Если появляются новые инциденты с этим AI, то добавляем комментарий и туда.
Чтобы избежать дублирования, обработанные AI (которые могут вылиться в SPProblem) храним в locke.

### UpdateMeetingOnduty
Добавляет во встречу по отсмотру ночных звонков дежурных с прошлой и текущей недели.
В конфиг файле задается соответствие abc сервиса из которого получаем дежурного и id повторяющейся встречи куда надо добавить дежурных сервиса.
Дежурные получаются из abc на дату встречи (встреча в понедельник, пересменка дежурных тоже в понедельник).
Можно переиспользовать для других встреч/сервисов по передаче дежурства.
{% cut "Пример" %}
```yaml
  services:
    sre_vteam: 58701537
```
Джоба найдет ближайшую встречу с id 58701537, и на дату этой встречи получит дежурных из abc сервиса sre_vteam.
Полученные дежурные автоматически добавятся в эту встречу.
{% endcut %}


### UpdateSPIReviewEvent
Обновляет встречи по отсмотру инцидентов.
Находит следующую встречу по отсмотру, и все SPI по сервисам связанным с этой встречей за прошедшую неделю.
Прошедшая неделя считается как дата встречи минус 7 дней.
В конфиге джобы, в разделе events, задается соответствие встречи и компонент warden, инциденты которых надо добавить во встречу.

{% cut "Пример" %}

```yaml
events:
  40268884:
    - mail
    - calendar
  51677039:
    - telemost
    - datasync
    - yandex_360
    - disk
```
В ближайшую по календарю встречу с id 40268884 будут добавлены, все инциденты за неделю warden компонент mail и calendar.
А во встречу с id 51677039 будут добавлены, все инциденты за неделю warden компонент telemost, datasync, yandex_360 и disk.
{% endcut %}

### MeetingsAnnouncements
Делает анонс о встречах по разбору
Находит следующую встречу по разбору (задается в конфиге). Если время до встречи меньше чем задано в конфиге,
то парсим описание, находим все инциденты там и через YaIncBot делаем оповещение в чаты.
Чаты указываются для каждой встрече отдельно в конфиге.

### SendDrillsResultsJob
Отправляет результаты сервисных учений в сервис Ученьки.
Парсит очереди в стартреке, указанные в конфиге, которые не помечены тегом, проверяет наличие инцидентов и то, что
событие в инфре завершено. Если есть инцидены, то матчит их с названиями сервисов, которые указаны в тегах тикета.
На каждый сервис, перечисленный в тегах, генерирует результат в зависимости от наличия связанного SPI к этому сервису.

### SreInventoryJob
Модуль инвентаризации хозяйства в SRE. Раз в сутки проверяет сервисы по пунктам и создает в MAILSRE, если появились новые проблемы.
Словарь с предыдущим состоянием хранит в yt.

Сейчас умеет:
- Проверять статус валидации алертов в Warden
- Проверять наличие документации в Warden

Чтобы создать новые проверки, нужно:
1. В enum utils.const.InventoryOptions дописать код новой проверки
2. В jobs.sre_inventory.SreInventoryJob.run_once() по аналогии с существующими проверками описать логику проверки и добавлять результат
в словарь validation_dict по ключу проверки (значение описать в любой в необходимой структуре)
3. В шаблоне templates/inventory_ticket.jinja2 добавить человекопонятное описание в DESCRIPTIONS, обработать отрисовку результата для тикета
4. В конфиге добавить код проверки для нужного сервиса

## Как запустить?
1. Установить зависимости из requirements.txt
4. export YT_TOKEN= (обязательно)
5. export INFRA_TOKEN=,ABC_TOKEN=,ST_TOKEN=,CALENDAR_TOKEN=,WARDEN_TOKEN=,UCHENKI_TOKEN= (при необходимости для конктреных джоб)
6. Можно отключить ненужные джобы в конфиге (disabled: False)
7. python3 src/spihelper/main.py --config config/local.yaml

## Как выкатить?
Через CI: https://a.yandex-team.ru/projects/sre_vteam/ci/releases/timeline?dir=mail%2Fsre%2Fspihelper&id=release
