from http_clients.base import HttpClient
from utils.config import config
from requests.exceptions import ReadTimeout


class InfraClient(HttpClient):
    base_url = config.infra.url or 'https://infra-api.yandex-team.ru/v1'
    oauth = config.infra_token
    decode_json = True
    timeout = 15

    def get_event(self, id: str or int) -> dict:
        try:
            return self.r.get(f"/events/{id}")
        except ReadTimeout:
            return {}
