from http_clients.base import HttpClient
from utils.config import config


class UchenkiClient(HttpClient):
    base_url = config.uchenki.url or 'https://uchenki.yandex-team.ru/api/v1'
    decode_json = True
    oauth = config.uchenki_token
    timeout = 15

    def post_trainings(self, data: dict) -> dict:
        return self.r.post(url='/training/closing_results', json=data)

    def post_degrade(self, data: dict) -> dict:
        return self.r.post(url='/training/degradation_results', json=data)
