from datetime import datetime
from typing import List

import attr
import cattr

from http_clients.base import HttpClient
from http_clients.calendar import Person
from utils.config import config
from utils.utils import datetime_converter


@attr.s(frozen=True, str=False, repr=False)
class Shift:
    id: int = attr.ib()
    is_primary: bool = attr.ib()
    start: datetime = attr.ib(converter=datetime_converter)
    end: datetime = attr.ib(converter=datetime_converter)
    schedule_id: int = attr.ib()

    staff: Person = attr.ib()

    def __str__(self):
        return f"Shift id:{self.id} \"duty: {self.staff.login}\" start: {self.start.strftime('%Y-%m-%d %H:%M')}"

    __repr__ = __str__


class WatcherClient(HttpClient):
    base_url = config.watcher.url or "https://abc-back.yandex-team.ru/api/v1"
    decode_json = True
    tvm_client_id = config.watcher.tvm_client_id

    def shift_list(self, filter: str = None, fields: str = None, **kwargs) -> List[Shift]:
        # https://abc-back.yandex-team.ru/api/watcher/docs/swagger#/shift/list
        response = self.r.get(
            "/shift/",
            params={
                "filter": filter,
                "fields": fields,
                **kwargs,
            },
            tvm_client_id=self.tvm_client_id,
        )

        attr.resolve_types(Shift, globals(), locals())
        return cattr.structure(response.get("result", []), List[Shift])
