from typing import Dict

from http_clients.base import HttpClient
from utils.config import config


class YaIncBotClient(HttpClient):
    base_url = config.yaincbot.url
    decode_json = True
    timeout = 30.0

    def send_notify(self, msg: str, chats: list = None, parse_mode: str = "HTML", buttons: list = None) -> Dict:
        data = {
            "text": msg,
            "parse_mode": parse_mode,
            "stream": "none",
            "chats": chats,
            "buttons": buttons
        }
        result = self.r.post('training/notify', json=data)

        return result
