#!/usr/bin/env python3
import pytz as pytz
from apscheduler.schedulers.blocking import BlockingScheduler
from loguru import logger

from jobs import jobs
from utils.config import config
from utils.logconf import initialize_logging

if __name__ == '__main__':
    initialize_logging(config)
    logger.info("launching app")
    scheduler = BlockingScheduler(logger=logger, timezone=pytz.timezone('Europe/Moscow'))

    for job in jobs:
        init_job = job(config)
        scheduler.add_job(init_job.run, **init_job.scheduler_settings)

    try:
        scheduler.start()
    except (KeyboardInterrupt, SystemExit):
        scheduler.shutdown()
        logger.info("stop app")
