from sys import stderr

from loguru import logger, _better_exceptions
from ujson import dumps

from utils.config import Config


def deploy_formatter(record):
    record["extra"]["serialized"] = dumps(
        {
            "@timestamp": record["time"].isoformat(),
            "message": record["message"],
            "stackTrace": "".join(
                _better_exceptions.ExceptionFormatter().format_exception(
                    record["exception"].type, record["exception"].value, record["exception"].traceback
                )
            )
            if record["exception"]
            else None,
            "levelStr": record["level"].name,
            "level": record["level"].no,
            "loggerName": f"{record['name']}:{record['function']}",
            # extra
            "line": record["line"],
            "threadName": record["file"].path,
        }
    )
    return "{extra[serialized]}\n"


def initialize_logging(config: "Config"):
    logger.remove()
    if config.logging.stdout.enabled:
        format = {"format": deploy_formatter} if config.logging.stdout.json_formatted else {}
        logger.add(stderr, enqueue=True, **format)
    if config.logging.file.enabled:
        logger.add(
            config.logging.file.path,
            rotation=config.logging.file.rotation_rule,
            retention=config.logging.file.retention_count,
            compression="gz",
        )
