import jinja2 as jinja2

from utils.config import config

templates_dir = config.templates_dir
templates_env = jinja2.Environment(
    loader=jinja2.FileSystemLoader(templates_dir), autoescape=jinja2.select_autoescape(["html"])
)


def render_template(name: str, context: dict):
    template = templates_env.get_template(name)
    return template.render(**context)
