from typing import Union

from tvm2 import TVM2
from tvmauth import BlackboxTvmId

from utils.config import config


class TVM2Error(Exception):
    pass


def get_tvm_client():
    return TVM2(
        client_id=config.self_tvm_id,
        secret=config.tvm_token,
        blackbox_client=BlackboxTvmId.ProdYateam,
    )


def get_service_ticket(client_id: str) -> str:
    tvm_client = get_tvm_client()
    service_ticket = tvm_client.get_service_ticket(client_id)

    if not service_ticket:
        raise TVM2Error('Failed to get TVM user ticket by robot token from Blackbox')
    return service_ticket


def get_robot_user_ticket() -> str:
    tvm_client = get_tvm_client()
    user_ticket = tvm_client.get_user_ticket(
        user_ip='127.0.0.1',  # в данном случае не влияет ни на что, bb принимает там что угодно, даже пустую строку
        server_host=config.hostname,
        oauth_token=config.yt_token,
    )
    if not user_ticket:
        raise TVM2Error('Failed to get TVM user ticket by robot token from Blackbox')
    return user_ticket


def get_tvm_headers(client_id: Union[str, int], robot_user_ticket: bool = False):
    service_ticket = get_service_ticket(str(client_id))
    headers = {
        "X-Ya-Service-Ticket": service_ticket,
    }

    if robot_user_ticket:
        headers["X-Ya-User-Ticket"] = get_robot_user_ticket()

    return headers
