import argparse
import re
import subprocess
import tempfile
import os
from jinja2 import Environment, FileSystemLoader


def get_args():
    parser = argparse.ArgumentParser(description=("Render and deploy spec templates"))
    group = parser.add_mutually_exclusive_group(required=True)
    group.add_argument("-f", "--put", action="store_true",
                        default=None, help="Force deploy stage without draft")
    group.add_argument("-p", "--publish", action="store_true",
                        default=None, help="Publish draft to deploy UI")
    group.add_argument("-r", "--render", action="store_true",
                        default=None, help="Just render and print jinja template")
    parser.add_argument("spec_file", nargs=1)
    return parser.parse_args()


def create_full_spec(filename):
    env = Environment(loader=FileSystemLoader('.'), )
    jinja_template = env.get_template(filename)
    render = jinja_template.render()
    return re.sub(re.compile('^ *\n', re.MULTILINE), '', render)


def save_spec_to_file(spec):
    temp_file = tempfile.NamedTemporaryFile(mode="w", delete=False)
    temp_file.write(spec)
    print("Spec saved to {}".format(temp_file.name))
    return temp_file.name


def publish(spec):
    spec_file = save_spec_to_file(spec)
    publish_draft_cmd = "ya tool dctl publish-draft stage {}".format(spec_file)
    p = subprocess.Popen(publish_draft_cmd.split())
    p.wait()
    os.remove(spec_file)


def put(spec):
    spec_file = save_spec_to_file(spec)
    put_stage_cmd = "ya tool dctl put stage {}".format(spec_file)
    p = subprocess.Popen(put_stage_cmd.split())
    p.wait()
    os.remove(spec_file)


def render(spec):
    print(spec)


def main():
    args = get_args()
    full_spec = create_full_spec(args.spec_file[0])
    for arg, value in vars(args).items():
        if value is True:
            eval(arg + "(full_spec)")


if __name__ == '__main__':
    main()
