# coding: utf-8

import argparse
import requests
import logging
import library.python.vault_client as vault_client

from requests.adapters import HTTPAdapter, Retry

logging.basicConfig(level=logging.DEBUG)

API_URL = 'https://its.yandex-team.ru/v1/values'


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('--status', action='store_true', help='show handle status')
    parser.add_argument('--handle', required=True, help='its handle')
    parser.add_argument('--off', action='store_true')
    parser.add_argument('--on', action='store_true')

    args = parser.parse_args()

    yav = vault_client.instances.Production()
    args.token = yav.get_version('sec-01f3x5vr4ng6akdapf0y687n9g')['value']['its.token']

    return args


# main
def main():
    args = parse_args()

    session = requests.Session()
    session.headers.update({
        'Authorization': f'OAuth {args.token}',
    })
    retries = Retry(total=5, backoff_factor=1, status_forcelist=[502, 503, 504, 429])
    session.mount('https://', HTTPAdapter(max_retries=retries))

    r = session.get('{}/{}/'.format(API_URL, args.handle))

    is_off = r.status_code == 200

    if args.status:
        if is_off:
            print(f'{args.handle} currently is OFF')
        else:
            print(f'{args.handle} currently is ON')
        exit(0)

    if args.on:
        if is_off:
            etag = r.headers['ETag']
            r = session.delete(
                '{}/{}/'.format(API_URL, args.handle),
                headers={'If-Match': etag},
            )
            if r.status_code == 204:
                print(f'{args.handle} turned ON')
                exit(0)
            else:
                print(f'failed to turn on {args.handle}:')
                print(r)
                exit(1)
        else:
            print(f'{args.handle} is already turned ON')
            exit(0)

    if args.off:
        if is_off:
            print(f'{args.handle} is already turned off')
            exit(0)
        r = session.post(
            '{}/{}/'.format(API_URL, args.handle),
            json={'value': ''},
        )
        if r.status_code == 200:
            print(f'{args.handle} turned OFF')
            exit(0)
        else:
            print(f'failed to turn off {args.handle}')
            print(r)
            exit(1)


if __name__ == '__main__':
    main()
