# coding: utf-8

import argparse
import math
import requests
import logging
import library.python.vault_client as vault_client

from requests.adapters import HTTPAdapter, Retry

logging.basicConfig(level=logging.DEBUG)

API_URL = 'https://ext.its.yandex-team.ru/v2/l7/heavy'
SECTION_ID = 'bygeo'
KNOWN_DCS=['IVA', 'MYT', 'SAS', 'VLA']


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('--balancer', required=True, help='balancer')
    parser.add_argument('--status', help='show balancer status')
    parser.add_argument('--off', help='dc to switch off')

    args = parser.parse_args()

    yav = vault_client.instances.Production()
    args.token = yav.get_version('sec-01f3x5vr4ng6akdapf0y687n9g')['value']['its.token']

    if args.status:
        args.status = args.status.upper()
        assert args.status in KNOWN_DCS
    elif args.off:
        args.off = args.off.upper()
        assert args.off in KNOWN_DCS

    return args


# main
def main():
    args = parse_args()

    session = requests.Session()
    session.headers.update({
        'Authorization': f'OAuth {args.token}',
    })
    retries = Retry(total=5, backoff_factor=1, status_forcelist=[502, 503, 504, 429])
    session.mount('https://', HTTPAdapter(max_retries=retries))

    # Получаем веса
    r = session.get('{}/{}/weights/values/'.format(API_URL, args.balancer))
    data = r.json()
    locations = data['sections'][SECTION_ID]['locations']
    locs = list(locations.keys())
    if args.status:
        assert args.status in locs
        print('Вес {dc}: {weight}'.format(dc=args.status, weight=locations[args.status]['weight']))
        exit(0)

    etag = r.headers['ETag']
    print('Текущие веса:')
    print(locations)

    # Обновляем веса секции
    w = 100
    l = len(locs)
    if args.off:
        assert args.off in locs
        l -= 1
        locs.remove(args.off)
        data['sections'][SECTION_ID]['locations'][args.off]['weight'] = 0
    for i, loc in enumerate(locs):
        data['sections'][SECTION_ID]['locations'][loc]['weight'] = math.floor(100 / len(locs)) if i < l - 1 else w
        w -= math.floor(100 / l)

    print('Устанавливаем веса:')
    print(data['sections'][SECTION_ID]['locations'])

    r = session.post('{}/{}/weights/values/'.format(API_URL, args.balancer), json=data, headers={'If-Match': etag})
    etag = r.headers['ETag']
    current_db_version = etag.strip('"')

    # Получаем текущие веса из ITS
    r = session.get('{}/{}/weights/its_value/'.format(API_URL, args.balancer))
    data = r.json()
    current_its_version = data['current_version']

    # Пушим обновлённые веса в ITS
    r = session.post('{}/{}/weights/its_value/'.format(API_URL, args.balancer), json={
        'current_version': current_its_version,
        'target_version': current_db_version,
    })
    data = r.json()
    current_its_version = data['current_version']

    # Проверяем, что всё хорошо
    assert current_db_version == current_its_version


if __name__ == '__main__':
    main()
