from abc import ABC, abstractmethod


class BaseCommand(ABC):
    @abstractmethod
    def name(self):
        pass

    @abstractmethod
    def description(self):
        pass

    def run(self, args):
        raise NotImplementedError()

    def run_for_cluster(self, cluster, args):
        raise NotImplementedError()


def get_all_commands():
    command_classes = BaseCommand.__subclasses__()
    commands = {}
    for cmd_class in command_classes:
        cmd = cmd_class()
        commands[cmd.name()] = cmd
    return commands
