from .base import BaseCommand, get_all_commands
import sys


class HelpCommand(BaseCommand):
    def _print_usage(self):
        commands = get_all_commands()
        print(f'usage: {sys.argv[0]} [cluster] subcommand [subcommand args]')
        print('possible subcommands: ')
        for name, command in commands.items():
            print(f'\t{name}: {command.description()}')

    def name(self):
        return 'help'

    def description(self):
        return 'prints help in general and for every command'

    def run(self, args):
        self._print_usage()

    def run_for_cluster(self, cluster, args):
        self._print_usage()
