from .base import BaseCommand
import subprocess


class YcCommand(BaseCommand):
    def _run_yc(self, cluster_id, args):
        process = subprocess.Popen(['yc', 'managed-postgresql', '--cluster-id', cluster_id] + args,
                                    stdout=subprocess.PIPE, stderr=subprocess.PIPE, universal_newlines=True)
        return process.communicate()

    def name(self):
        return 'yc'

    def description(self):
        return 'wrapper for "yc managed-postgresql" command, to simplify folder/cluster/cloud selection'

    def run_for_cluster(self, cluster, args):
        stdout, stderr = self._run_yc(cluster.id, args)
        if stderr:
            print(stderr)
        else:
            print(stdout)
