from ..utils.http import load_json
import json

IAM_URL = 'https://iam.cloud.yandex-team.ru:443/v1/tokens'


class ApiAuthProvider:
    def __init__(self, oauth_token):
        self.oauth_token = oauth_token
        self.iam_token = self._get_iam_token(oauth_token)

    def _get_iam_token(self, oauth_token):
        payload = json.dumps({
            'yandexPassportOauthToken': oauth_token
        }).encode()
        res = load_json(IAM_URL, post_data=payload, add_headers={'Content-Type': 'application/json'})
        return res['iamToken']

    def header_value(self):
        return f'Bearer {self.iam_token}'
