from ..utils.http import load_json, urlencode

API_URL = 'https://gw.db.yandex-team.ru'


class BaseApi():
    def __init__(self, api_type, auth_provider):
        self.api_type = api_type
        self.auth_provider = auth_provider

    def call_method(self, method, get_params=None):
        url = f'{API_URL}/{self.api_type}/{method}'
        if get_params:
            url += f'?{urlencode(get_params)}'
        return load_json(url, add_headers={'Authorization': self.auth_provider.header_value()})
