from .base import BaseApi


class Cloud:
    def __init__(self, id, name):
        self.id = id
        self.name = name


class CloudApi(BaseApi):
    def __init__(self, auth_provider):
        super().__init__('resource-manager', auth_provider)

    def list(self):
        clouds = self.call_method('v1/clouds')['clouds']
        return [Cloud(c['id'], c['name']) for c in clouds]
