from .base import BaseApi


class Cluster:
    def __init__(self, folder_id, id, name):
        self.folder_id = folder_id
        self.id = id
        self.name = name


class ClusterApi(BaseApi):
    def __init__(self, auth_provider, folder):
        super().__init__('managed-postgresql', auth_provider)
        self.folder = folder

    def list(self):
        clusters = self.call_method('v1/clusters', {
            'folder_id': self.folder.id
        })['clusters']
        return [Cluster(c['folderId'], c['id'], c['name']) for c in clusters]
