from .base import BaseApi


class Folder:
    def __init__(self, cloud_id, id, name):
        self.cloud_id = cloud_id
        self.id = id
        self.name = name


class FolderApi(BaseApi):
    def __init__(self, auth_provider, cloud):
        super().__init__('resource-manager', auth_provider)
        self.cloud = cloud

    def list(self):
        folders = self.call_method('v1/folders', {
            'cloud_id': self.cloud.id
        })['folders']
        return [Folder(f['cloudId'], f['id'], f['name']) for f in folders]
