import json
import urllib
from urllib.error import HTTPError
from urllib.request import urlopen, Request


def load_url(url, add_headers={}, post_data=None):
    request = Request(url, headers=add_headers, data=post_data)
    resp = urlopen(request)
    return resp


def load_json(url, add_headers={}, post_data=None):
    resp = load_url(url, add_headers, post_data).read()
    return json.loads(resp)


def urlencode(args, prefix=''):
    return (prefix + urllib.parse.urlencode(args)) if args else ''
