import json
from os.path import expanduser


class KeyValueStorage:
    def __init__(self, filename):
        self.filename = expanduser(filename)
        try:
            with open(self.filename, 'r') as f:
                self.data = json.load(f)
        except FileNotFoundError:
            self.data = {}

    def __getitem__(self, key):
        return self.data[key]

    def __setitem__(self, key, value):
        self.data[key] = value
        with open(self.filename, 'w') as f:
            json.dump(self.data, f)

    def __contains__(self, key):
        return key in self.data
