#!/bin/bash

[[ "$TRACE" ]] && set -x

HOSTS_FILE='.prepared'
[[ -f "$HOSTS_FILE" ]] || touch $HOSTS_FILE

function get_cgroup() {

    local srv=$1
    local env=$2
    # TODO: разные окружения и сервисы из списка выбирать
    if [[ "$srv" == "mbody" ]] || [[ "$srv" == "xivahub" ]] && [[ "$env" == "intranet-production" ]]; then
        env="corp"
    fi
    if [[ "$srv" == "xivahub" ]] && [[ "$env" == "sandbox" ]]; then
        env="sandbox_hub-shard2"
    fi
    if [[ "$srv" == "xivahub" ]] && [[ "$env" == "prooduction" ]]; then
        env="production_hub-shard24"
    fi
    if [[ "$srv" == "xiva-server" ]] && [[ "$env" == "sandbox" ]]; then
        env="sandbox_xiva"
    fi
    if [[ "$srv" == "xivamob" ]] && [[ "$env" == "sandbox" ]]; then
        env="sandbox_mobile"
    fi

    echo %mail_${srv}_${env}
}

function get_random_host()
{
    local cgroup=$1

    hosts_string=$(executer --quiet "p_exec ${cgroup} env | grep QLOUD_HOSTNAME" | cut -f 2 -d '=' | grep qloud)
    hosts_array=($hosts_string)

    echo ${hosts_array[$((RANDOM%${#hosts_array[@]}))]}

}

function prepare()
{
    action=$1
    service=$2
    environment=$3
    if [[ $# -lt 3 ]] ; then
        usage
    fi

    cgroup=$(get_cgroup $service $environment)

    exist_host=$(grep $cgroup $HOSTS_FILE | cut -f 2 -d ' ')
    echo ${action}

    if [[ -z ${exist_host} ]] && [[ "$action" = "prepare" ]]; then
        echo "preparing service $cgroup"
        host=$(get_random_host $cgroup)
        chmod +x ./manage_alerts/*
        scp -r "./manage_alerts" ${host}:/tmp/
        if [ $? -ne 0 ]; then echo "can not copy scripts to host: ${host}"; exit 1; fi
        # TODO: генерим алерты или отправляем в бота
        echo ${cgroup} ${host} >> ${HOSTS_FILE}
        echo ${host}
    elif [[ "$action" = "finish" ]]; then
        if [[ -n ${exist_host} ]] ; then
            echo "finish for service: $cgroup host: $exist_host";
            # TODO: остановить все алерты
            ssh ${exist_host} "rm -rf /tmp/manage_alerts"
            sed -i '' "/${cgroup}/d" ${HOSTS_FILE}
        else
            echo "can not finish for service: $cgroup host is not prepared"
            exit 1
        fi
    else
        echo "service $cgroup is prepared on host: $exist_host"
        exit 1
    fi

    exit 0
}

function control_alert()
{
    action=$1
    service=$2
    alert=$3
    unispace_deleted=$5

    exist_host=$(grep ${service} ${HOSTS_FILE} | cut -f 2 -d ' ')
    if [[ -z ${exist_host} ]] && [[ "$action" = "prepare" ]]; then
        echo "service ${service} is not prepared"
        exit 1
    fi
    env=$(grep ${service} ${HOSTS_FILE} | egrep -o 'sandbox|corp|production|intranet-production')
    ssh ${exist_host} "/tmp/manage_alerts/manage.sh ${action} ${alert} ${service} ${env} ${unispace_deleted}"

    echo "Done"
}

function usage() {
    echo "Usage: $0 {action} {service} {environment}"
    echo "action: for service {prepare, finish} or for alerts {start, stop}"
    echo "service: xivahub, xiva-server, hound, mops, settings"
    echo "environment: production, intranet-production, sandbox (only for xivahub, xiva-server, xivamob)"
    echo "Examples:"
    echo "./destroy.sh prepare xivahub corp - selects a random host from the service xivahub_corp and copies scripts "
    echo "./destroy.sh start xivahub dns - start alert dns on xivahub"
    echo "./destroy.sh stop xivahub dns - stop alert dns on xivahub"
    echo "./destroy.sh finish xivahub corp - remove scripts from xivahub host"
    exit 0
}

# start
if [[ $# -eq 0 ]] ; then
    usage
fi

case "$1" in
    -h | --help)
        usage
        ;;
    start | stop )
        control_alert $@
        ;;
    prepare | finish)
        prepare $@
        ;;
    *)
        usage
        exit 1
        ;;
esac
