
#TODO: сделать отдельную функцию под правильное определение шардов для каждого сервиса или блокирвку одного шарда для WMI
resolv_file='/etc/resolv.conf'
resolv_dump_file='/tmp/resolv.conf.default'
resolve_fake='search search.yandex.net yandex.ru\nnameserver ::1\noptions timeout:1 attempts:1'

resolv_pgpass_file="/tmp/.pgpass.default"
bogus_cert='
-----BEGIN CERTIFICATE-----
MIIB+zCCAWQCCQCmwG53y9G4tjANBgkqhkiG9w0BAQUFADBCMQswCQYDVQQGEwJS
VTEVMBMGA1UEBwwMRGVmYXVsdCBDaXR5MRwwGgYDVQQKDBNEZWZhdWx0IENvbXBh
bnkgTHRkMB4XDTE0MDEyMzE2MjY0NFoXDTE1MDEyMzE2MjY0NFowQjELMAkGA1UE
BhMCUlUxFTATBgNVBAcMDERlZmF1bHQgQ2l0eTEcMBoGA1UECgwTRGVmYXVsdCBD
b21wYW55IEx0ZDCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAtKEdZKoYPYsb
fjj+Gv41cI08gb0M4h4B2bxU8dlpS0SsJo/H85UPx1eLAcBpLmMEuEjapUMWOiJ1
jPs3RfMmkhaUmFEV1sTjFfny5o3pBqahzsAsMEcdf1JNApTJ2GNYGaPG+TrJKBLm
ayqeRtxiCC0wg1zLVD5yzcxFUI/rC50CAwEAATANBgkqhkiG9w0BAQUFAAOBgQBc
u8MlfIHUpSulrMI+Y1Yqov4EaLLM9XGEEvQlWktOvqktTfsTzIAtg7Ms/2hZ4QvJ
QcDARc4STDM/SQYSDz2RDzgvG2vXHcvqkUFrDl3g1lhFYcfUu/MJmG52/dV0zw0H
cQAvBJljzSEHU/UXyX1qaxdguxmu3xKCybvJtABMYA==
-----END CERTIFICATE-----
'

function get_service_user
{
    local service=$1

    case "$service" in
        xivahub | xivamob | xiva-server) user='xiva';;
        hound | mops | settings) user='wmi';;
        *)   echo "unknown service"; return 1;;
    esac
    echo ${user}
}

function get_db_hosts()
{
    local service=$1
    local env=$2

    if [[ "$env" == "intranet-production" ]] || [[ "$env" == "corp" ]]; then
        case "$service" in
            xivahub) echo "sas-l2cypx5wkcmyauw0.db.yandex.net vla-rvyq7983xx2vxcni.db.yandex.net man-f3bkfg28xys1l14s.db.yandex.net";;
            settings | mops | hound) echo "corp-sharpei.mail.yandex.net";;
            xiva-server) echo "production.xivahub.mail.stable.qloud-d.yandex.net " ;;
            *)   echo "unknown service"; return 1;;
        esac
    elif [[ "$env" == "production" ]]; then
        case "$service" in
            xivahub) echo "vla-6t357ocxtww200io.db.yandex.net myt-879wgupguxgb3u1m.db.yandex.net sas-fc47qlamci3p3cw0.db.yandex.net";;
            settings | mops | hound) echo "sharpei.mail.yandex.net";;
            xiva-server) echo "corp.xivahub.mail.stable.qloud-d.yandex.net " ;;
            *)   echo "unknown service"; return 1;;
        esac
    elif [[ "$env" == "sandbox" ]]; then
        case "$service" in
            xivahub) echo "vla-f8bnzvjg8g01420y.db.yandex.net iva-tzmrsd3v15ui51vs.db.yandex.net myt-k6m2dl6mvdhkgxun.db.yandex.net vla-s4kc17ilwx75yx2u.db.yandex.net iva-jqn7gb8r7nzzp713.db.yandex.net myt-coovc8e5ubiu1alu.db.yandex.net sas-ymejctb28q8mkih7.db.yandex.net vla-p0mn7bx1s7yqbw0y.db.yandex.net sas-ymejctb28q8mkih7.db.yandex.net vla-p0mn7bx1s7yqbw0y.db.yandex.net
";;
            xiva-server) echo "sandbox.xivahub.mail.stable.qloud-d.yandex.net" ;;
            *)   echo "unknown service"; return 1;;
        esac
    fi

}

function get_peer_adresess()
{
    local service=$1
    local env=$2

    if [[ "$env" == "intranet-production" ]] || [[ "$env" == "corp" ]]; then
        case "$service" in
            xivahub) echo "xivamob.mail.yandex.net xivamobcorp.mail.yandex.ne";;
            settings | mops | hound) echo "corp-sharpei.mail.yandex.net";;
            xiva-server) echo "akita.mail.yandex.net" ;;
            *)   echo "unknown service"; return 1;;
        esac
    elif [[ "$env" == "production" ]]; then
        case "$service" in
            xivahub) echo "reaper-sandbox.mail.yandex.net xivamob-sandbox.mail.yandex.net";;
            settings | mops | hound) echo "blackbox.yandex.net blackbox-mail.yandex.net storage.mail.yandex.net tvm-api.yandex.net sanitizer2.mail.yandex.net";;
            xiva-server) echo "akitacorp.mail.yandex.net" ;; #
            *)   echo "unknown service"; return 1;;
        esac
    elif [[ "$env" == "sandbox" ]]; then
        case "$service" in
            xivahub) echo "reaper-sandbox.mail.yandex.net xivamob-sandbox.mail.yandex.net";;
            xiva-server) echo "akita-test.mail.yandex.net" ;;
            *)   echo "unknown service"; return 1;;
        esac
    fi

}

function random_word()
{
    egrep -x '[a-z]+' /usr/share/dict/words | shuf -n 1 --random-source=/dev/urandom
}

function block_outgoing_ipv6_traffic()
{
    ip6tables -A OUTPUT -d "$1" -j DROP
}

function destroy_dns_resolver()
{
    cat $resolv_file > $resolv_dump_file && echo -e "$resolve_fake" > $resolv_file && portoctl restart app/sub_main
}

function block_all_db_hosts()
{
    local service=$1
    local env=$2
    hosts=$(get_db_hosts $service $env)
    db_hosts=($hosts)

    for host in ${db_hosts[*]}; do block_outgoing_ipv6_traffic $host ; done
}

function inject_bogus_pg_cert()
{
    local service=$1
    user=$(get_service_user $service)
    pgcert_path="/home/${user}/.postgresql/root.crt"
    echo "$bogus_cert" > "$pgcert_path"
    case "$service" in
        xivahub | xiva-server) portoctl restart app/sub_main;;
        hound ) supervisorctl restart hound;;
        mops )  supervisorctl restart mops;;
        settings ) supervisorctl restart settings;;
        *)   echo "unknown service"; return 1;;
    esac

}

function scramble_pgpgass()
{
    local service=$1
    user=$(get_service_user $service)
    pgpass_path="/home/${user}/.pgpass"
    # TODO: пока сработает только для xiva, надо улучшить
    cat $pgpass_path > $resolv_pgpass_file
    while fgrep -q xiva "$pgpass_path"; do
        sed -i "s/xiva/xeno/" "$pgpass_path"
    done
    case "$service" in
        xivahub | xiva-server) portoctl restart app/sub_main;;
        hound ) supervisorctl restart hound;;
        mops )  supervisorctl restart mops;;
        settings ) supervisorctl restart settings;;
        *)   echo "unknown service"; return 1;;
    esac
#    sed -i "s/dirty-password/$(random_word)/" "$pgpass_path"
}

function block_network()
{
    local service=$1
    local env=$2
    peers=$(get_peer_adresess $service $env)
    peer_adresses=($peers)
    for peer in ${peer_adresses[*]}; do block_outgoing_ipv6_traffic $peer ; done
}

function pgpass_mode_start()
{
    local service=$1
    user=$(get_service_user $service)
    pgpass_path="/home/${user}/.pgpass"

    chmod a+r "$pgpass_path"
}

function 5xx_stop()
{
    local service=$1

    user=$(get_service_user $service)
    # TODO: вынести в отдельную функцию получение этих путей
    pgpass_path="/home/${user}/.pgpass"
    pgcert_path="/home/${user}/.postgresql/root.crt"

    if [ -f $resolv_dump_file ]; then
        cat $resolv_dump_file > $resolv_file
        rm -f $resolv_dump_file
    fi
    if [ -f $resolv_pgpass_file ]; then
        cat $resolv_pgpass_file > $pgpass_path
        rm -f $resolv_pgpass_file
    fi

    ip6tables -F
    wget "https://crls.yandex.net/allCAs.pem" -qO "$pgcert_path"
    chmod 0600 "$pgpass_path"
    killall -q psql || true
}
