#!/usr/bin/env bash
# Both find_ functions are inexact, but should prove sufficient.
function find_needle()
{
    total_bytes=$(df -B1 --output=size,target | grep '/$' | egrep -o '[0-9]+')
    find /var -size +$((total_bytes * 90 / 100))c
}

function find_hog()
{
    lsof -w | fgrep /var/ | fgrep deleted | cut -d ' ' -f 2
}

hog_code='#!/usr/bin/python3

import time
import sys
f = open(sys.argv[1])
while True:
    time.sleep(600)
'

function hog_file()
{
    file_name=$1
    hog_name=hog_file
    hog_path="/tmp/$hog_name.py"
    echo "$hog_code" > "$hog_path"
    chmod a+x "$hog_path"
    portoctl run "app/sub_$hog_name" \
        respawn=false \
        isolate=false \
        command="$hog_path $file_name"
    while ! $(lsof -w | fgrep -q $file_name); do
        echo "waiting for hog to start..."
        sleep 2
    done
}

function unispace_start()
{
    service=$1
    env=$2
    emulate_deleted=$3

    # Put a big file somewhere in '/var/log'.
    available_bytes=$(df -B1 --output=avail,target | grep '/$' | egrep -o '[0-9]+')
    target_free_bytes=100000000
    needle_size_bytes=$((available_bytes-target_free_bytes))

    needle_dir=$(find /var/log/ -maxdepth 1 -type d | shuf -n 1 --random-source=/dev/urandom)
    needle_name=${service}_${env}.log
    needle_path=$needle_dir/$needle_name

    fallocate -l $needle_size_bytes "$needle_path"
    if [[ $emulate_deleted ]]; then
        hog_file "$needle_path"
        rm "$needle_path"
    fi
}

function unispace_stop()
{
    rm -f $(find_needle)
    kill $(find_hog)
    portoctl gc
}
