#!/usr/bin/env bash

 # TODO: удобнее сделать группировку и добавление новых алертов
SCRIPTS_PATH=/tmp/manage_alerts
for alert_functions in $(ls ${SCRIPTS_PATH}/alerts/*.sh); do
    source "$alert_functions"
done

function start()
{
    alert=$2
    service=$3
    env=$4
    unispace_deleted=$5

    case "$alert" in
        network)  block_network ${service} ${env};;
        dns)  destroy_dns_resolver;;
        pg_network) block_all_db_hosts ${service} ${env};;
        pg_cert) inject_bogus_pg_cert ${service};;
        pg_pass_mode) pgpass_mode_start ${service};;
        pg_password) scramble_pgpgass ${service};;
        unispace) unispace_start ${service} ${env} ${unispace_deleted};;
        *)   echo "unknown cause: $alert"; return 1;;
    esac
}


function stop()
{
    alert=$2
    service=$3

    if [[ "$alert" == "unispace" ]]; then
        unispace_stop
    else
        5xx_stop ${service}
    fi
}


case "$1" in
    start )
        start $@
        ;;
    stop)
        stop $@
        ;;
esac
