from flask import Flask
from flask_swagger_ui import get_swaggerui_blueprint


def make_swagger_ui_app(swagger_url, api_url):
    app = Flask(__name__)
    swaggerui_blueprint = get_swaggerui_blueprint(
        swagger_url,
        api_url,
    )
    app.register_blueprint(swaggerui_blueprint, url_prefix=swagger_url)
    return app
