import os

import click

from mail.swagger_ui.app import make_swagger_ui_app


@click.command()
@click.option('--swagger_url', default='/api/docs')
@click.option('--api_url', default=os.environ.get('SWAGGER_API_URL'))
@click.option('--host', default='::')
@click.option('--port', type=int, default=80)
def main(swagger_url: str, api_url: str, host: str, port: int):
    app = make_swagger_ui_app(swagger_url=swagger_url, api_url=api_url)
    app.run(host=host, port=port, debug=True, use_reloader=False)
