package cmd

import (
	"context"
	"os"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/mail/swat/dutytool/pkg"
	"a.yandex-team.ru/mail/swat/dutytool/pkg/ctl"
)

var cli = &ctl.Cli{
	QloudAPIURL:   "https://qloud-ext.yandex-team.ru",
	SolomonAPIURL: "https://solomon.yandex-team.ru",
	YcAPIURL:      "https://gw.db.yandex-team.ru",
	YcIAMAPIURL:   "https://iam.cloud.yandex-team.ru",
}

var rootCmd = &cobra.Command{
	Use: pkg.AppName,
	PersistentPreRunE: func(cmd *cobra.Command, args []string) error {
		configPath, _ := cmd.Flags().GetString("config")
		if configPath == "" {
			configPath = os.Getenv("DUTYTOOL_CONFIG")
		}
		return cli.Initialize(context.Background(), configPath)
	},
}

func Execute() error {
	rootCmd.PersistentFlags().String("config", "", "Path to config")
	return rootCmd.Execute()
}
