package ctl

type Drill struct {
	CmdClose   string   `mapstructure:"cmd_close"`
	Skip       bool     `mapstructure:"skip"`
	CmdOpen    string   `mapstructure:"cmd_open"`
	Components []string `mapstructure:"components"`
	Comment    string   `mapstructure:"comment"`
}

func (d Drill) HasComponent(name string) bool {
	for _, item := range d.Components {
		if item == name {
			return true
		}
	}
	return false
}

// Qloud
type QloudEnvironment struct {
	Name   string      `json:"name"`
	Drills interface{} `json:"drills"`
}

type QloudApplication struct {
	Name         string             `json:"name"`
	Environments []QloudEnvironment `json:"environments"`
}

type QloudProject struct {
	Name         string             `json:"name"`
	Applications []QloudApplication `json:"applications"`
}

type Qloud struct {
	Projects []QloudProject `json:"projects"`
}

func (q Qloud) AmountEnvs() int {
	result := 0
	for _, project := range q.Projects {
		for _, application := range project.Applications {
			for range application.Environments {
				result += 1
			}
		}
	}
	return result
}

type YavSecret struct {
	SecretID        string `yaml:"secret_id"`
	SecretVersionID string `yaml:"secret_version_id"`
}

type DeployStageSpecDescriptor struct {
	TemplateArcadiaPath    string    `yaml:"template_arcadia_path"`
	DelegationTokensSecret YavSecret `yaml:"delegation_tokens_secret"`
}

// Deploy
type DeployStage struct {
	Name      string                    `json:"name"`
	Drills    interface{}               `json:"drills"`
	StageSpec DeployStageSpecDescriptor `yaml:"stage_spec"`
}

type AwacsStage struct {
	Name string `json:"name"`
}

type DeployProject struct {
	Name   string        `json:"name"`
	Stages []DeployStage `json:"stages"`
	Awacs  []AwacsStage  `json:"awacs"`
}

type Deploy struct {
	Projects []DeployProject `json:"projects"`
}

func (s Deploy) AmountStages() int {
	result := 0
	for _, project := range s.Projects {
		for range project.Stages {
			result += 1
		}
	}
	return result
}

// YC
type YcCluster struct {
	Type string `json:"type"`
	ID   string `json:"id"`
}

type Yc struct {
	Clusters []YcCluster `json:"clusters"`
}

// Config
type Config struct {
	Qloud  Qloud  `json:"qloud"`
	Yc     Yc     `json:"yc"`
	Deploy Deploy `json:"deploy"`
}
