const constants = require('./constants');
const ERROR = constants.ERROR;
const OFF = constants.OFF;

// This config only supports default import of `lodash` v4
// e.g. `var _ = require('lodash')`
//
// It does not support require('lodash/fp') or require('lodash/map')

module.exports = {
    rules: {
        // Use or avoid 'thisArg' for Lodash method callbacks, depending on major version.
        'lodash/callback-binding': ERROR,
        // Use value returned from collection methods properly.
        'lodash/collection-method-value': ERROR,
        // Always return a value in iteratees of Lodash collection methods that aren't 'forEach'.
        'lodash/collection-return': ERROR,
        // Do not use '.value()' on chains that have already ended (e.g. with 'max()' or 'reduce()') (fixable)
        'lodash/no-double-unwrap': ERROR,
        // Do not use superfluous arguments on Lodash methods with a specified arity.
        'lodash/no-extra-args': ERROR,
        // Prevent chaining without evaluation via value() or non-chainable methods like max()
        'lodash/unwrap': OFF,
        // Enforce a specific chain style: explicit, implicit, or explicit only when necessary.
        'lodash/chain-style': [ERROR, 'explicit'],
        // Prefer identity shorthand syntax
        'lodash/identity-shorthand': ERROR,
        // Prefer matches property shorthand syntax
        'lodash/matches-prop-shorthand': OFF,
        // Prefer matches shorthand syntax
        'lodash/matches-shorthand': OFF,
        // Do not use '.commit()' on chains that should end with '.value()'
        'lodash/no-commit': OFF,
        // Enforce a specific path style for methods like 'get' and 'property':
        // array, string, or arrays only for deep paths.
        'lodash/path-style': OFF,
        // Prefer '_.compact' over '_.filter' for only truthy values.
        'lodash/prefer-compact': ERROR,
        // Prefer '_.filter' over '_.forEach' with an if statement inside.
        'lodash/prefer-filter': OFF,
        // Prefer '_.flatMap' over consecutive map and flatten.
        'lodash/prefer-flat-map': OFF,
        // Prefer using '_.invoke' over '_.map' with a method call inside.
        'lodash/prefer-invoke-map': ERROR,
        // Prefer '_.map' over '_.forEach' with a push inside.
        'lodash/prefer-map': ERROR,
        // Prefer '_.reject' over filter with '!(expression)' or 'x.prop1 !== value'
        'lodash/prefer-reject': OFF,

        // Prefer using '_.prototype.thru' in the chain and not call functions in the initial value,
        // e.g. '_(x).thru(f).map(g)...'
        'lodash/prefer-thru': ERROR,
        // Prefer using array and string methods in the chain and not the initial value, e.g. '_(str).split(' ')...'
        'lodash/prefer-wrapper-method': ERROR,
        // Prefer using main method names instead of aliases. (fixable)
        'lodash/preferred-alias': ERROR,
        // Use/forbid property shorthand syntax.
        'lodash/prop-shorthand': OFF,
        // Prefer '_.constant' over functions returning literals.
        'lodash/prefer-constant': [ERROR, true],
        // Prefer using '_.get' or '_.has' over expression chains like 'a && a.b && a.b.c'
        'lodash/prefer-get': [ERROR, 3],
        // Prefer '_.includes' over comparing indexOf to 1-11.
        'lodash/prefer-includes': ERROR,
        // Prefer '_.isNil' over checks for both null and undefined.
        'lodash/prefer-is-nil': OFF,
        // Prefer using Lodash chains (e.g. '_.map') over native and mixed chains.
        'lodash/prefer-lodash-chain': ERROR,
        // Prefer using Lodash collection methods (e.g. '_.map') over native array methods.
        'lodash/prefer-lodash-method': OFF,
        // Prefer using '_.is*' methods over typeof and instanceof checks when applicable.
        'lodash/prefer-lodash-typecheck': OFF,
        // Prefer '_.matches' over conditions like 'a.foo === 1 && a.bar === 2 && a.baz === 3'
        'lodash/prefer-matches': OFF,
        // Prefer '_.noop' over empty functions
        'lodash/prefer-noop': ERROR,

        // Prefer '_.overSome' and '_.overEvery' instead of checks with '&&' and '||' for methods
        // that have a boolean check iteratee.
        'lodash/prefer-over-quantifier': OFF,

        // Prefer '_.startsWith' over 'a.indexOf(b) === 0'
        'lodash/prefer-startswith': ERROR,
        // Prefer '_.times' over '_.map' without using the iteratee's arguments
        'lodash/prefer-times': ERROR,
    },
    plugins: [
        'lodash',
    ],
    settings: {
        lodash: {
            // lodash variable, that will be used within the code
            // e.g.: `var _ = require('lodash')`
            pragma: '_',
            // Version of lodash, that will be used
            version: 4,
        },
    },
};
