const constants = require('./constants');
const ERROR = constants.ERROR;
const OFF = constants.OFF;
const WARN = constants.WARN;

module.exports = {
    settings: {
        react: {
            version: "detect"
        }
    },
    rules: {
        // Prevent missing 'displayName' in a React component definition
        'react/display-name': [ERROR, {ignoreTranspilerName: false}],
        // Forbid certain propTypes
        'react/forbid-prop-types': [OFF, {
            forbid: ['any', 'array', 'object'],
        }],
        // Prevent usage of dangerous JSX properties
        'react/no-danger': OFF,
        // Prevent usage of deprecated methods
        'react/no-deprecated': ERROR,
        // Prevent usage of 'setState' in 'componentDidMount'
        'react/no-did-mount-set-state': [ERROR],
        // Prevent usage of 'setState' in 'componentDidUpdate'
        'react/no-did-update-set-state': [ERROR],
        // Prevent direct mutation of 'this.state'
        'react/no-direct-mutation-state': ERROR,
        // Prevent usage of 'isMounted'
        'react/no-is-mounted': ERROR,
        // Prevent multiple component definition per file
        'react/no-multi-comp': [ERROR, {ignoreStateless: false}],
        // Prevent usage of 'setState'
        'react/no-set-state': OFF,
        // Prevent using string references in 'ref' attribute
        'react/no-string-refs': ERROR,
        // Prevent usage of unknown DOM property (fixable)
        'react/no-unknown-property': ERROR,
        // Enforce ES5 or ES6 class for React Components
        'react/prefer-es6-class': ERROR,
        // Enforce stateless React Components to be written as a pure function
        'react/prefer-stateless-function': ERROR,
        // Prevent missing props validation in a React component definition
        'react/prop-types': ERROR,
        // Enforce ES5 or ES6 class for returning value in render function
        'react/require-render-return': ERROR,
        // Prevent extra closing tags for components without children
        'react/self-closing-comp': ERROR,
        // Enforce component methods order
        'react/sort-comp': [ERROR, {
            order: [
                'static-methods',
                'lifecycle',
                '/^handle[A-Z0-9]\S*$/', // eslint-disable-line no-useless-escape
                '/^(?:get|set)(?!(?:InitialState|DefaultProps|ChildContext)$).+$/',
                'everything-else',
                '/^render[A-Z0-9]\S*$/',  // eslint-disable-line no-useless-escape
                'render',
            ],
        }],
        // Enforce propTypes declarations alphabetical sorting
        'react/sort-prop-types': [OFF, {
            callbacksLast: false,
            ignoreCase: false,
            requiredFirst: true,
        }],
        /**
         * JSX
         * -------------------------------------------------
         */
        // enforce a maximum line length
        'max-len': [ERROR, {
            code: 140,
            comments: 140,
            tabWidth: 2,
            ignoreComments: false,
            ignoreTrailingComments: false,
            ignoreUrls: false,
            ignorePattern: '^(?:(?:\\s*var\\s.+=\\s*require\\s*\\(.+)|(?:import\\s.+))$',
        }],
        // enforce the consistent use of either double or single quotes in JSX attributes
        'jsx-quotes': [ERROR, 'prefer-double'],
        // Prevent missing React when using JSX
        'react/react-in-jsx-scope': ERROR,
        // Prevent missing parentheses around multilines JSX
        'react/jsx-wrap-multilines': [WARN, {
            declaration: true,
            assignment: true,
            return: true,
        }],
        // Enforce boolean attributes notation in JSX
        'react/jsx-boolean-value': [WARN, 'never'],
        // Validate closing bracket location in JSX
        'react/jsx-closing-bracket-location': [WARN, 'line-aligned'],
        // Enforce or disallow spaces inside of curly braces in JSX attributes
        'react/jsx-curly-spacing': [WARN, 'never', {allowMultiline: true}],
        // Enforce or disallow spaces around equal signs in JSX attributes
        'react/jsx-equals-spacing': [WARN, 'never'],
        // Enforce position of the first prop in JSX
        'react/jsx-first-prop-new-line': [ERROR, 'multiline'],
        // Enforce event handler naming conventions in JSX
        'react/jsx-handler-names': [OFF, {
            eventHandlerPrefix: 'handle',
            eventHandlerPropPrefix: 'on',
        }],
        // Validate props indentation in JSX
        'react/jsx-indent-props': [WARN, 2],
        // Validate JSX indentation
        'react/jsx-indent': [WARN, 2],
        // Validate JSX has key prop when in array or iterator
        'react/jsx-key': ERROR,
        // Limit maximum of props on a single line in JSX
        'react/jsx-max-props-per-line': [OFF, {
            maximum: 1,
        }],
        // Prevent usage of '.bind()' and arrow functions in JSX props
        'react/jsx-no-bind': [ERROR, {
            ignoreRefs: true,
            allowArrowFunctions: false,
            allowBind: false,
        }],
        // Prevent duplicate props in JSX
        'react/jsx-no-duplicate-props': [ERROR, {ignoreCase: false}],
        // Prevent usage of unwrapped JSX strings
        'react/jsx-no-literals': OFF,
        // Prevent usage of unsafe `target='\_blank'`
        'react/jsx-no-target-blank': ERROR,
        // Disallow undeclared variables in JSX
        'react/jsx-no-undef': ERROR,
        // Enforce PascalCase for user-defined JSX components
        'react/jsx-pascal-case': [WARN, {allowAllCaps: false}],
        // Enforce props alphabetical sorting
        'react/jsx-sort-props': [OFF, {
            callbacksLast: false,
            ignoreCase: false,
            shorthandFirst: true,
        }],
        // Validate spacing before closing bracket in JSX
        'react/jsx-tag-spacing': [ERROR, {
            "beforeClosing": "allow"
        }],
        // Prevent React to be incorrectly marked as unused
        'react/jsx-uses-react': ERROR,
        // Prevent variables used in JSX to be incorrectly marked as unused
        'react/jsx-uses-vars': ERROR,
    },
    parserOptions: {
        ecmaFeatures: {
            jsx: true,
        },
    },
    plugins: [
        'react',
    ],
};
